/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#include "hfiles.h"
#include "headers.h"
#include "cache_loadmeta.h"

CacheVal< LoadMetaDataOut, LoadMetaDataIn > meta_cache;

// Creates temporary Named DB name and/or ODBC DSN name if they are necessary (P.SQL 2000 )
static HRESULT CreateTemporaryStorageNames( char *lpszTempODBC, CSwstMeta* pSwstMetaINFORMATION_SCHEMA, LPSTR lpszDdfPath, LPSTR lpszDataPath, LPCOLESTR lpwszDatabaseName, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverType, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword )
{

	return S_OK;	// Correct 
}

/////
LoadMetaDataIn::LoadMetaDataIn(CSwstMeta* pSwstMetaINFORMATION_SCHEMA, LPCSTR lpszDDPath, LPCSTR lpszDataPath, LPCOLESTR lpwszDatabaseName, LPCOLESTR lpwszOwner, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverID, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword, LPOLESTR pwszMySqlStr ) 
{
	CLEAR_CONSTRUCT( LoadMetaDataIn );

    m_pSwstMetaINFORMATION_SCHEMA = pSwstMetaINFORMATION_SCHEMA;
	strcpy0(m_szDdfPath, lpszDDPath, MAXSTR( m_szDdfPath ) );
	strcpy0(m_szDataPath, lpszDataPath, MAXSTR( m_szDataPath ) );
	memcpy(m_wszDatabaseName, lpwszDatabaseName, sizeof(m_wszDatabaseName) ); 
	m_wszDatabaseName[ MAXSTR(m_wszDatabaseName) - 1 ] = L'\0';
	wcscpy0(m_wszOwner,	lpwszOwner ? lpwszOwner : L"", MAXSTR(m_wszOwner) );
	m_typeOfDataSource = typeOfDataSource;
	m_iDriverID = iDriverID;
	strcpy0( m_szServerName, lpszServerName, MAXSTR(m_szServerName) );
	strcpy0( m_szUser, lpszUser, MAXSTR(m_szUser) );
	strcpy0( m_szPassword, lpszPassword, MAXSTR(m_szPassword) );
    wcscpy0( m_wszMySqlStr, pwszMySqlStr, MAXSTR(m_wszMySqlStr) );
}

/////
bool LoadMetaDataIn::operator==( const LoadMetaDataIn& cmp ) const {
    return 
        (m_pSwstMetaINFORMATION_SCHEMA && cmp.m_pSwstMetaINFORMATION_SCHEMA ||
         !m_pSwstMetaINFORMATION_SCHEMA && !cmp.m_pSwstMetaINFORMATION_SCHEMA) &&
        strcmp0( m_szDdfPath, cmp.m_szDdfPath ) == 0 &&
        strcmp0( m_szDataPath, cmp.m_szDataPath ) == 0 &&
        wcscmp0( m_wszOwner, cmp.m_wszOwner ) == 0 &&
        wcscmp0( m_wszDatabaseName, cmp.m_wszDatabaseName ) == 0 &&
        m_typeOfDataSource == cmp.m_typeOfDataSource &&
        m_iDriverID == cmp.m_iDriverID &&
        strcmp0( m_szServerName, cmp.m_szServerName ) == 0 &&
        strcmp0( m_szUser, cmp.m_szUser ) == 0 &&
        strcmp0( m_szPassword, cmp.m_szPassword ) == 0 &&
        wcscmp0( m_wszMySqlStr, cmp.m_wszMySqlStr ) == 0 ;
}

/////
HRESULT TempODBC::create( LoadMetaDataIn& in )
{
	HRESULT hr = CreateTemporaryStorageNames( 
            m_szTempODBC, in.m_pSwstMetaINFORMATION_SCHEMA, in.m_szDdfPath, 
			in.m_szDataPath, in.m_wszDatabaseName, in.m_typeOfDataSource, 
			in.m_iDriverID, in.m_szServerName, in.m_szUser, in.m_szPassword );

	wcscpy0( m_wszOwner, in.m_wszOwner ? in.m_wszOwner : L"", MAXSTR(m_wszOwner) );
	strcpy0( m_szServerName, in.m_szServerName, MAXSTR(m_szServerName) );
	strcpy0( m_szUser, in.m_szUser, MAXSTR(m_szUser) );
	strcpy0( m_szPassword, in.m_szPassword, MAXSTR(m_szPassword) );

    return hr;
}

///// 
void TempODBC::destroy()
{
	if( *m_szTempODBC != '\0' && *m_wszOwner == L'\0' )
	{
//		DropUserDSN( m_szTempODBC, m_szServerName, m_szUser, m_szPassword );
//		DropDbName( m_szTempODBC, m_szServerName, m_szUser, m_szPassword );
	}
}

/////
void LoadMetaDataOut::update( LoadMetaDataIn &in ) 
{ 
    CSwstMeta::Destroy(); //destroy old state
    CLEAR_CONSTRUCT( CSwstMeta );
    m_hr = LoadMetaData_Slow(
        in.m_pSwstMetaINFORMATION_SCHEMA, 
        in.m_szDdfPath, 
        in.m_szDataPath, 
        in.m_wszDatabaseName, 
        in.m_wszOwner, 
        in.m_typeOfDataSource, 
        in.m_iDriverID, 
        in.m_szServerName, 
        in.m_szUser, 
        in.m_szPassword,
        in.m_wszMySqlStr );
    if( m_hr == S_OK ) {
        m_pTempODBC = new TempODBC();
        m_hr = m_pTempODBC->create( in );
        strcpy0( m_szTempODBC, m_pTempODBC->m_szTempODBC, MAXSTR(m_szTempODBC) );
    }
}

/////
HRESULT LoadMetaDataOut::decode( CSwstMeta &SwstMeta ) {
    SwstMeta = *this;
    return m_hr;
}

/////
HRESULT CSwstMeta::LoadMetaData(CSwstMeta* pSwstMetaINFORMATION_SCHEMA, LPCSTR lpszDDPath, LPCSTR lpszDataPath, LPCOLESTR lpwszDatabaseName, LPCOLESTR lpwszOwner, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverID, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword, LPOLESTR pwszMySqlStr )
{
    LoadMetaDataIn in(
        pSwstMetaINFORMATION_SCHEMA==this || !pSwstMetaINFORMATION_SCHEMA ? 0 : pSwstMetaINFORMATION_SCHEMA, 
        lpszDDPath, 
        lpszDataPath, 
        lpwszDatabaseName, 
        lpwszOwner, 
        typeOfDataSource, 
        iDriverID, 
        lpszServerName, 
        lpszUser, 
        lpszPassword,
        pwszMySqlStr );
 
    return meta_cache.update( in ).decode( *this );
}