import java.awt.*;
import java.awt.event.*;

class YesNoDialog extends Dialog
{
    private Button okButton;
    private Button cancelButton;

    private boolean selection = false;

    public YesNoDialog (Frame parent, String title, String text, String ok_text, String cancel_text) 
    {
	super (parent, title, true);
	
	GridBagLayout gbl = new GridBagLayout();
	GridBagConstraints gbc = new GridBagConstraints();
	setLayout (gbl);

	Panel panel1 = new Panel();
	panel1.setLayout (gbl);

	addToContainer (panel1,
			gbl,
			gbc,
			new Label (text),
			0,
			0,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.NORTHWEST,
			0, 0);

	// add panel1 to the dialog box
	addToContainer (this,
			gbl,
			gbc,
			panel1,
			0,
			0,
			5,
			1,
			GridBagConstraints.BOTH,
			GridBagConstraints.NORTHWEST,
			1, 0,
			new Insets (5, 5, 5, 5));

	Panel panel2 = new Panel();
	panel2.setLayout (gbl);

	okButton = new Button (ok_text);
	okButton.addActionListener (new OkListener());
	addToContainer (panel2,
			gbl,
			gbc,
			okButton,
			0,
			0,
			1,
			1,
			GridBagConstraints.NONE,
			GridBagConstraints.CENTER,
			0, 0,
			new Insets (0, 0, 0, 5));	

	if (cancel_text != null)
	    {
		cancelButton = new Button (cancel_text);
		cancelButton.addActionListener (new CancelListener());
		addToContainer (panel2,
				gbl,
				gbc,
				cancelButton,
				1,
				0,
				1,
				1,
				GridBagConstraints.NONE,
				GridBagConstraints.CENTER,
				0, 0);	
	    }

	// add panel2 to the dialog box
	addToContainer (this,
			gbl,
			gbc,
			panel2,
			0,
			1,
			1,
			1,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.CENTER,
			1, 0,
			new Insets (0, 5, 5, 5));

	pack();
	Rectangle pbounds = parent.getBounds();
	Point mid = new Point (pbounds.x + (pbounds.width/2), pbounds.y + (pbounds.height/2));
	Rectangle bounds = getBounds();	
	int x = mid.x - (bounds.width/2);
	int y = mid.y - (bounds.height/2);	
	if (x < 0) x = pbounds.x;
	if (y < 0) y = pbounds.y;
	setBounds (x, y, bounds.width, bounds.height);
	
	show();
    }

    public boolean okSelected()
    {
	return selection;
    }

   private void addToContainer (Container cont,
				 GridBagLayout gbl,
				 GridBagConstraints gbc,
				 Component comp,
				 int gridx,
				 int gridy,
				 int gridwidth,
				 int gridheight,
				 int fill,
				 int anchor,
				 int weightx,
				 int weighty,
				 Insets insets)
    {
	gbc.gridx = gridx;
	gbc.gridy = gridy;
	gbc.gridwidth = gridwidth;
	gbc.gridheight = gridheight;
	gbc.fill = fill;
	gbc.anchor = anchor;
	gbc.weightx = weightx;
	gbc.weighty = weighty;

	if (insets != null)
	    {
		gbc.insets = insets;
	    }

	gbl.setConstraints (comp, gbc);
	cont.add (comp);
    }

    private void addToContainer (Container cont,
				 GridBagLayout gbl,
				 GridBagConstraints gbc,
				 Component comp,
				 int gridx,
				 int gridy,
				 int gridwidth,
				 int gridheight,
				 int fill,
				 int anchor,
				 int weightx,
				 int weighty)
    {
	addToContainer (cont, gbl, gbc, comp, gridx, gridy, gridwidth, gridheight,
			fill, anchor, weightx, weighty, null);
    }

    class CancelListener implements ActionListener
    {
	public void actionPerformed (ActionEvent e)
	{
	    YesNoDialog.this.dispose();
	}
    };

    class OkListener implements ActionListener
    {
	public void actionPerformed (ActionEvent e)
	{
	    selection = true;
	    YesNoDialog.this.dispose();
	}
    };
}


