package mysqladmin;

/** GenerateSwing, generates Java-Swing Code out of a table and is a part of Admin...
 *  Version 1.1 01. June 1999
 *  Fredy Fischer 
 *
 *  this has been created to query mySQL-Databases
 *  it only returns a JPanel, so it can easily been 
 *  used in different kind of windows
 */


/** Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/


import java.util.*;
import java.sql.*;


public class GenerateSwing {

    Vector v;
    
    String swingCode;
    
    /**
       * Set the value of swingCode.
       * @param v  Value to assign to swingCode.
       */
    public void setSwingCode(String  v) {this.swingCode = v;}
    
    private String firstUpper(String s) {
	s = s.substring(0,1).toUpperCase() + s.substring(1);
	return s;
    }

    private String toDay() {

	Calendar c = Calendar.getInstance();
   
	return  Integer.toString(c.get(Calendar.YEAR)) + "-" + 
	        Integer.toString(c.get(Calendar.MONTH)+1)+ "-" + 
                Integer.toString(c.get(Calendar.DATE));

    }


    private String getType(String s) {
	String t="String";

       if ( Integer.parseInt(s) ==  java.sql.Types.CHAR )          t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.VARCHAR )       t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.LONGVARCHAR )   t = "String";;
       if ( Integer.parseInt(s) ==  java.sql.Types.BINARY )        t = "String";;
       if ( Integer.parseInt(s) ==  java.sql.Types.LONGVARBINARY ) t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.VARBINARY )     t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.DATE )          t = "java.sql.Date";
       if ( Integer.parseInt(s) ==  java.sql.Types.TIME )          t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.TIMESTAMP )     t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.OTHER )         t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.INTEGER )       t = "int";
       if ( Integer.parseInt(s) ==  java.sql.Types.DOUBLE )        t = "double";
       if ( Integer.parseInt(s) ==  java.sql.Types.FLOAT )         t = "float";

       return t;
    }

    
    String database;
    
    /**
       * Get the value of database.
       * @return Value of database.
       */
    public String getDatabase() {return database;}
    
    /**
       * Set the value of database.
       * @param v  Value to assign to database.
       */
    public void setDatabase(String  v) {this.database = v;}
    
    
    String table;
    
    /**
       * Get the value of table.
       * @return Value of table.
       */
    public String getTable() {return table;}
    
    /**
       * Set the value of table.
       * @param v  Value to assign to table.
       */
    public void setTable(String  v) {this.table = v;}
    

    

    int lng;
    
    /**
       * Get the value of the length when to switch from TextField to TextArea.
       * @return Value of lng.
       */
    public int getLng() {return lng;}
    
    /**
       * Set the value of length when to switch from TextField to TextArea.
       * @param v  Value to assign to lng.
       */
    public void setLng(int  v) {this.lng = v;}
    

    int noRows;
    
    /**
       * Get the value of number of Rows in a TextArea.
       * @return Value of number of Rows in a TextArea.
       */
    public int getNoRows() {return noRows;}
    
    /**
       * Set the value of number of Rows in a TextArea.
       * @param v  Value to assign to number of Rows in a TextArea.
       */
    public void setNoRows(int  v) {this.noRows = v;}
    
    public GenerateSwing(Vector v, String db) {

	this.v = v;
	setDatabase(db);
	setLng(30);
	setNoRows(5);

    }

    public String getSwingCode() {

	Columns c = new Columns();
	c = (Columns) v.elementAt(0);
	setTable(c.getTable());

	swingCode = "package applications." + getDatabase() + ";\n\n" +
	    "/** this has been generated by Fredy's Admin-Tool for SQL-Databases\n" +
	    " *  this is a Swing-Form\n\n" +
	    " *  Date: " + toDay() + "\n" +
	    " * \n" +
	    " *  Table:    " + getTable() + "\n" +
	    " *  Database: " + getDatabase() + "\n" +
	    " *\n" +
	    " *  Admin is under GPL\n" +
	    " *\n" +
	    " *  Fredy Fischer\n" +
	    " *  Hulmenweg 36\n" +
	    " *  8405 Winterthur\n" +
	    " *  Switzerland\n" +
	    " *\n" +
	    " * se-afs@dial.eunet.ch\n" +
	    " *\n" +
	    " **/\n" +
	    "\n" +
	    "import java.awt.*;\n" +
	    "import java.awt.event.*;\n" +
	    "import java.util.*;\n" +
	    "import javax.swing.*;\n" +
	    "import javax.swing.BorderFactory; \n" +
	    "import javax.swing.border.Border;\n" +
	    "import javax.swing.border.TitledBorder;\n" +
	    "import javax.swing.JLabel;\n" +
	    "import javax.swing.JPanel; \n" +
	    "import javax.swing.JFrame;\n" +
	    "import javax.swing.event.*;\n" +
	    "import javax.swing.text.*;\n" +
	    "import javax.swing.border.*;\n" +
	    "import java.awt.datatransfer.*;\n" +
	    "import applications.basics.ButtonPanel;\n" +
	    "import applications.basics.sqlTable;\n" +
	    "\n" +
	    "public  class " + firstUpper(getTable()) + "Grid" + "  extends JTabbedPane {\n" +
	    "\n" +
	    "    public JTable list;\n" +
	    "    private JPanel     listPanel;\n" +
	    "    private JComboBox  search;\n" +
	    "    private JCheckBox  exact;\n" +
	    "    private JTextField searchString;\n" +
	    "\n";
	for (int i = 0; i < v.size(); i++) {
	    c = new Columns();
	    c = (Columns) v.elementAt(i);
	    if (getType(c.getType()).startsWith("String") && c.getLng() > getLng() ) {
		swingCode = swingCode + "    private JTextArea " + c.getName() + ";\n";
	    } else {
		swingCode = swingCode + "    private JTextField " + c.getName() + ";\n";
	    }

	}
	    swingCode = swingCode + "    public ButtonPanel bp;\n" +
	    "\n" +
	    "\n" +
	    "\n" +
	    "    String host;\n" +
	    "  \n" +
	    "    /**\n" +
	    "       * Get the value of host.\n" +
	    "       * @return Value of host.\n" +
	    "       */\n" +
	    "    public String getHost() {return host;}\n" +
	    "    \n" +
	    "    /**\n" +
	    "       * Set the value of host.\n" +
	    "       * @param v  Value to assign to host\n" +
	    "       */\n" +
	    "    public void setHost(String  v) {this.host = v;}\n" +
	    "    \n" +
	    "    String user;\n" +
	    "    \n" +
	    "    /**\n" +
	    "       * Get the value of user.\n" +
	    "       * @return Value of user.\n" +
	    "       */\n" +
	    "    public String getUser() {return user;}\n" +
	    "    \n" +
	    "    /**\n" +
	    "       * Set the value of user.\n" +
	    "       * @param v  Value to assign to user.\n" +
	    "       */\n" +
	    "    public void setUser(String  v) {this.user = v;}\n" +
	    "    \n" +
	    "    String password;\n" +
	    "    \n" +
	    "    /**\n" +
	    "       * Get the value of password.\n" +
	    "       * @return Value of password.\n" +
	    "       */\n" +
	    "    public String getPassword() {return password;}\n" +
	    "    \n" +
	    "    /**\n" +
	    "       * Set the value of password.\n" +
	    "       * @param v  Value to assign to password.\n" +
	    "       */\n" +
	    "    public void setPassword(String  v) {this.password = v;}\n" +
	    "\n" +
	    "    public " + firstUpper(getTable()) + "Grid (String host, String user, String password) {\n" +
	    "\n" +
	    "	setHost(host);\n" +
	    "	setUser(user);\n" +
	    "	setPassword(password);\n" +
	    "\n" +
	    "	this.add(\"Form\",formPanel());\n" +
	    "	this.add(\"Search\",searchPanel());\n" +
	    "    }\n" + 
	    "\n" + 
	    "    private JPanel formPanel() {\n" + 
	    "\n";
	    int nowRows;
	    for (int i = 0; i < v.size(); i++) {
		c = new Columns();
		c = (Columns) v.elementAt(i);
	    if (getType(c.getType()).startsWith("String") && c.getLng() > getLng() ) { 
		nowRows = c.getLng()/getLng() + 1;
		if (nowRows > getNoRows()) nowRows = getNoRows();
	     	swingCode = swingCode + "    " + c.getName() + " = new JTextArea("+ Integer.toString(nowRows) + "," + Integer.toString(getLng()) +");\n";
		swingCode = swingCode + "    " + c.getName() + ".setLineWrap(true);\n";
	    } else {
		swingCode = swingCode + "    " + c.getName() + " = new JTextField(\"\"," + Integer.toString(c.getLng()) +");\n";
	    }
	    }
	    swingCode = swingCode +
	    "\n" + 
	    "	JPanel panel = new JPanel();\n" + 
	    "	panel.setLayout(new BorderLayout());\n" + 
	    "	bp = new ButtonPanel();	\n" + 
	    "	panel.add(\"South\",bp);\n" + 
	    "\n" + 
	    "	bp.insert.addActionListener(new ActionListener() {\n" + 
	    "	    public void actionPerformed(ActionEvent e) {\n" + 
	    "		insert(getRow());\n" + 
	    "		}});\n" + 
	    "	bp.delete.addActionListener(new ActionListener() {\n" + 
	    "	    public void actionPerformed(ActionEvent e) {\n" + 
	    "		delete(getRow());\n" + 
	    "		}});\n" + 
	    "	bp.update.addActionListener(new ActionListener() {\n" + 
	    "	    public void actionPerformed(ActionEvent e) {\n" + 
	    "		update(getRow());\n" + 
	    "		}});\n" + 
	    "	bp.clear.addActionListener(new ActionListener() {\n" + 
	    "	    public void actionPerformed(ActionEvent e) {\n" + 
	    "		clear();\n" + 
	    "		}});\n" + 
	    "	\n" + 
	    "\n" + 
	    "\n" + 
	    "	JPanel gridPanel = new JPanel();\n" + 
	    "	gridPanel.setLayout(new GridBagLayout());\n" + 
	    "\n" + 
	    "	GridBagConstraints gbc;\n" + 
	    "	Insets insets = new Insets(5,5,5,5);\n" + 
	    "        JScrollPane fScrollPane;\n" +
	    "\n\n"; 
	    for (int i = 0; i < v.size(); i++) {
		c = new Columns();
		c = (Columns) v.elementAt(i);
		swingCode = swingCode + 
	    "	gbc = new GridBagConstraints();\n" +
	    "	gbc.anchor=GridBagConstraints.NORTHEAST;\n" +
	    "	gbc.insets = insets;\n" +
	    "	gridPanel.add((JLabel) new JLabel(\"" + firstUpper(c.getName()) + "\"),gbc);\n" +
	    "	gbc = new GridBagConstraints ();\n" +
	    "	gbc.gridwidth = 0;\n" +
	    "	gbc.anchor=GridBagConstraints.WEST;\n" +
	    "	gbc.insets = insets;\n";
	    if (getType(c.getType()).startsWith("String") && c.getLng() > getLng() ) {
		swingCode = swingCode + "        fScrollPane = new JScrollPane(" +  c.getName() + ");\n";
		swingCode = swingCode + "        gridPanel.add(fScrollPane,gbc);\n";
	    } else {
		swingCode = swingCode + "        gridPanel.add(" + c.getName() + ",gbc);\n";
	    }
	    }
	    swingCode = swingCode + 
	    "\n" +
	    "	JScrollPane scrollpane = new JScrollPane(gridPanel);\n" +
	    "\n" +
	    "	panel.add(\"Center\",scrollpane);\n" +
	    "\n" +
	    "	return panel;\n" +
	    "\n" +
	    "    }\n" +
	    "\n" +
	    "\n" +
	    "    private JPanel searchPanel() {\n" +
	    "\n" +
	    "	final JPanel panel = new JPanel();\n" +
	    "	panel.setLayout(new BorderLayout());\n" +
	    "\n" +
	    "   final JPanel panel2 = new JPanel();\n" +
	    "	panel2.setLayout(new FlowLayout());\n" +
	    "\n" +
	    "	listPanel = new JPanel();\n" +
	    "\n" +
	    "	String[] items = {";

	    for (int i = 0; i < v.size(); i++) {
	        c = new Columns();
		c = (Columns) v.elementAt(i);
		swingCode = swingCode + "        \"" + c.getName() + "\",\n";
	    }
	    swingCode = swingCode + "	};\n" +
	    "	\n" +
	    "	search = new JComboBox(items);\n" +
	    "	exact  = new JCheckBox(\"exact search\");\n" +
	    "	exact.setSelected(true);\n" +
	    "	searchString = new JTextField(\"\",20);\n" +
	    "	JButton doIt = new JButton(\"Search\");\n" +
	    "	doIt.addActionListener(new ActionListener() {\n" +
	    "	    public void actionPerformed(ActionEvent e) {\n" +
	    "		String query = \"select * from " + getTable() + " where \";\n" +
	    "		String sel   = (String)search.getSelectedItem();\n" +
	    "		int    ind   = search.getSelectedIndex();\n" +
	    "		query = query + sel + \" \";\n" +
	    "		if (exact.isSelected()) {\n" +
	    "		   query = query + \"  = \";\n" +
	    "		} else { query  = query + \" like \"; }\n" +
	    "	        String s = searchString.getText();\n" +
	    "		switch (ind) {\n";
	    for (int i = 0; i < v.size(); i++) {
	        c = new Columns();
		c = (Columns) v.elementAt(i);
		String u = "\" \" ";
		if (getType(c.getType()).startsWith("String")) u = "\"'\"";
		swingCode = swingCode + 
	    "		case " + Integer.toString(i) + ":\n" +
	    "		    query = query + " + u + " + s + " + u + ";\n" +
	    "		    break;\n";
	    }
	    swingCode = swingCode + 
	    "		default:\n" +
	    "		    ;\n" +
	    "		}\n" +
	    "		query = query + \" order by \" + sel;\n" +
	    "		panel.remove(listPanel);\n" +
	    "           final sqlTable st = new sqlTable(getHost(), getUser(), getPassword(),\"" + getDatabase() +"\",query);\n" +
	    "		JScrollPane scp = new JScrollPane(st);\n" +
	    "		Dimension d = new Dimension();\n" +
	    "		d = panel.getSize();\n" +
	    " 	        Integer intx = new Integer(d.width);\n" +
	    "	        Integer inty = new Integer(d.height);\n" +
	    "	        double fx = intx.floatValue() * 0.95;\n" +
	    "	        double fy = inty.floatValue() * 0.65;\n" +
	    "	        Double dfx = new Double(fx);\n" +
	    "	        Double dfy = new Double(fy);\n" +
	    "		d.setSize(dfx.intValue(),dfy.intValue());\n" +
	    "		st.tableView.setPreferredScrollableViewportSize(d);\n" +
	    "		listPanel = new JPanel();\n" +
	    "		listPanel.add(scp);\n" +
	    "		panel.add(\"South\",listPanel);\n" +
	    "		panel.updateUI();\n" +
	    "\n" +
	    "		// as well there is needed a List Selection Listener\n" +
	    "		st.tableView.getSelectionModel().addListSelectionListener(new ListSelectionListener() {\n" +
	    "		    public void valueChanged(ListSelectionEvent e) {\n";
	    swingCode = swingCode + 
	    "		" + firstUpper(getTable()) + "Row k = new " + firstUpper(getTable()) + "Row(getHost(), getUser(),getPassword());\n" +
	    "\n" +
	    "			Integer i = new Integer(0);\n" +
	    "			Float f = new Float(0);\n" +
	    "			Double dbl = new Double(0);\n";
	    for (int i = 0; i < v.size(); i++) {
	        c = new Columns();
		c = (Columns) v.elementAt(i);
		if (getType(c.getType()).startsWith("String")) swingCode = swingCode + "			k.set" + firstUpper(c.getName()) + "((String)st.tableView.getValueAt(st.tableView.getSelectedRow()," + Integer.toString(i) + "));\n";
		    
                if (getType(c.getType()).startsWith("int")) {
		    swingCode = swingCode + 
	    "			i = (Integer)st.tableView.getValueAt(st.tableView.getSelectedRow()," + Integer.toString(i) + ");\n" +
	    "			k.set" + firstUpper(c.getName()) + "(i.intValue());\n";
		}		   

                if (getType(c.getType()).startsWith("float")) {
		    swingCode = swingCode + 
	    "			f = (Float)st.tableView.getValueAt(st.tableView.getSelectedRow()," + Integer.toString(i) + ");\n" +
	    "			k.set" + firstUpper(c.getName()) + "(f.floatValue());\n";
		}

                if (getType(c.getType()).startsWith("double")) {
		    swingCode = swingCode + 
	    "			dbl = (Double)st.tableView.getValueAt(st.tableView.getSelectedRow()," + Integer.toString(i) + ");\n" +
	    "			k.set" + firstUpper(c.getName()) + "(dbl.doubleValue());\n";
		}

                if (getType(c.getType()).startsWith("java.sql.Date")) {
		    swingCode = swingCode +  "			k.set" + firstUpper(c.getName()) + "((java.sql.Date)st.tableView.getValueAt(st.tableView.getSelectedRow()," + Integer.toString(i) + "));\n";

		}
	    }

	    swingCode = swingCode +
	    "\n" +
	    "\n" +
	    "			setRow(k);\n" +
	    "		    }});\n" +
	    "		}});\n" +
	    "	\n" +
	    "\n" +
	    "\n" +
	    "	panel2.add(search);\n" +
	    "	panel2.add(searchString);\n" +
	    "	panel2.add(exact);\n" +
	    "	panel2.add(doIt);\n" +
	    "	panel2.setBorder(BorderFactory.createEtchedBorder());\n" +
	    "\n" +
	    "	panel.add(\"North\",panel2);\n" +
	    "	panel.add(\"Center\",listPanel);\n" +
	    "	\n" +
	    "\n" +
	    "	return panel;\n" +
	    "\n" +
	    "    }\n" +
	    "\n" +
	    "\n" +
	    "    public " + firstUpper(getTable()) + "Row getRow() {\n\n" +
            "	     " + firstUpper(getTable()) + "Row k = new " + firstUpper(getTable()) + "Row(getHost(), getUser(), getPassword());\n\n";

	    for (int i = 0; i < v.size(); i++) {
	        c = new Columns();
		c = (Columns) v.elementAt(i);
		if (getType(c.getType()).startsWith("String")) swingCode = swingCode + "	k.set" + firstUpper(c.getName()) + "(" + c.getName() + ".getText());\n";
		    
                if (getType(c.getType()).startsWith("float")) {
		    swingCode = swingCode + 
            "	try {\n" +
            "	    k.set" + firstUpper(c.getName()) + "(Float.valueOf(" + c.getName() + ".getText()).floatValue());\n" +
            "	} catch (NumberFormatException e) { k.set" + firstUpper(c.getName()) + "(0); }\n" +
            "\n\n";

		}		   

                if (getType(c.getType()).startsWith("int")) {
		    swingCode = swingCode + 
            "	try {\n" +
            "	    k.set" + firstUpper(c.getName()) + "(Integer.parseInt(" + c.getName() + ".getText()));\n" +
            "	} catch (NumberFormatException e) { k.set" + firstUpper(c.getName()) + "(0); }\n" +
            "\n\n";

		}

                if (getType(c.getType()).startsWith("double")) {
		    swingCode = swingCode + 
            "	try {\n" +
            "	    k.set" + firstUpper(c.getName()) + "(Double.valueOf(" + c.getName() + ".getText()).doubleValue());\n" +
            "	} catch (NumberFormatException e) { k.set" + firstUpper(c.getName()) + "(0); }\n" +
            "\n\n";

		}

                if (getType(c.getType()).startsWith("java.sql.Date")) {
		    swingCode = swingCode + 
			"	try {\n" +
			"	    k.set" + firstUpper(c.getName()) + "(java.sql.Date.valueOf(" + c.getName() + ".getText()));\n" + 
			"       } catch (Exception e) { " + c.getName() + ".setText(\"yyyy-mm-dd\");\n           "  + c.getName() + ".selectAll();  }\n";
		}
		

	    }

	    swingCode = swingCode + "   return k;\n\n   }\n\n" +
            "\n" +
            "    public void insert(" + firstUpper(getTable()) + "Row k) { msg(k.insert()); }\n" +
            "    public void update(" + firstUpper(getTable()) + "Row k) { msg(k.update()); }\n" +
            "    public void delete(" + firstUpper(getTable()) + "Row k) { \n" +
            "	String string1 = \"Yes\";\n" +
            "	String string2 = \"No\";\n" +
            "	Object[] options = {string1, string2};\n" +
            "	int n = JOptionPane.showOptionDialog(null,\n" +
            "                              \"Do you really want to delete?\",\n " +
            "                              \"Delete  ?\",\n" +
            "                              JOptionPane.YES_NO_OPTION,\n" +
            "                              JOptionPane.QUESTION_MESSAGE,\n" +
            "                              null,     //don't use a custom Icon\n" +
            "                              options,  //the titles of buttons\n" +
            "                              string2); //the title of the default button\n" +
            "	     if (n == JOptionPane.YES_OPTION) {\n" +
            "		 String s = k.delete();\n" +
            "		 if (s.startsWith(\"ok\")) {\n" +
            "		     clear();\n" +
            "		 } else { msg(s);}\n" +
            "	     }\n" +
            "    }\n" +
            "\n" +
            "    private void msg(String s) {\n" +
            "	if (  ! s.startsWith(\"ok\") )  JOptionPane.showMessageDialog(null, s,\"Message\",JOptionPane.WARNING_MESSAGE);\n" +
            "    }\n\n";
	    swingCode = swingCode + 
            "    public void clear() {\n";
	    for (int i = 0; i < v.size(); i++) {
	        c = new Columns();
		c = (Columns) v.elementAt(i);
		swingCode = swingCode + "		" + c.getName() + ".setText(\"\");\n";
	    }
	    swingCode = swingCode +
            "    }\n\n" +
	    "    public void setRow(" + firstUpper(getTable()) + "Row k) {\n\n";
	    for (int i = 0; i < v.size(); i++) {
	        c = new Columns();
		c = (Columns) v.elementAt(i);
		if (getType(c.getType()).startsWith("String")) swingCode = swingCode + "	" + c.getName() + ".setText(k.get" + firstUpper(c.getName()) + "());\n";

		if (getType(c.getType()).startsWith("int")) swingCode = swingCode + "	" + c.getName() + ".setText(Integer.toString(k.get" + firstUpper(c.getName()) + "()));\n";

		if (getType(c.getType()).startsWith("float")) swingCode = swingCode + "	" + c.getName() + ".setText(Float.toString(k.get" + firstUpper(c.getName()) + "()));\n";

		if (getType(c.getType()).startsWith("double")) swingCode = swingCode + "	" + c.getName() + ".setText(Double.toString(k.get" + firstUpper(c.getName()) + "()));\n";
	    
		if (getType(c.getType()).startsWith("java.sql.Date")) swingCode = swingCode + "	" + c.getName() + ".setText(k.get" + firstUpper(c.getName()) + "().toString());\n";
	    }

	    swingCode = swingCode + "\n   }\n\n" +
	    "    public static void main(String args[]) {\n" +
	    "\n" +
	    "	if (args.length != 3) {\n" +
	    "	    System.out.println(\"Syntax: java applications." + getDatabase() + "." + firstUpper(getTable()) + "Grid host user password\");\n" +
	    "	    System.exit(0);\n" +
	    "	}\n" +
	    "	" + firstUpper(getTable()) + "Grid kg = new " + firstUpper(getTable()) + "Grid(args[0], args[1], args[2]);\n" +
	    "	JFrame frame = new JFrame(\"" + firstUpper(getTable()) + " Form\");\n" +
	    "	frame.getContentPane().setLayout(new BorderLayout());\n" +
	    "	frame.getContentPane().add(\"Center\",kg);\n" +
	    "	frame.addWindowListener(new WindowAdapter() {\n" +
	    "	    public void windowActivated(WindowEvent e) {}\n" +
	    "	    public void windowClosed(WindowEvent e) {}\n" +
	    "	    public void windowClosing(WindowEvent e) {System.exit(0);}\n" +
	    "            public void windowDeactivated(WindowEvent e) {}\n" +
	    "            public void windowDeiconified(WindowEvent e) {}\n" +
	    "            public void windowIconified(WindowEvent e) {}\n" +
	    "            public void windowOpened(WindowEvent e) {}});\n" +
	    "	kg.bp.cancel.addActionListener(new ActionListener() {\n" +
	    "	    public void actionPerformed(ActionEvent e) {\n" +
	    "		System.exit(0);\n" +
	    "		}});\n" +
	    "	frame.pack();\n" +
	    "	frame.setVisible(true);\n" +
	    "	\n" +
	    "    }\n" +
	    "}\n" ;
	    return swingCode;
    }
}
