
##################################################################
##								##
##			This module is 				##
##           (C) 1999,2000 Perl4YOU software group. 		##
##								##
##	  You are free to redistribute the source code,		##
##	 use it in commercial projects and so on, leaving 	##
##		    this copyright untouched.			##
##								##
##                   Visit our website at 			##
##                 http://www.perl4you.com			##
##								##
##################################################################

package HandyLog;

use strict;

use vars qw($logfname $logremote $prefix $oldreferer $oldvia);

BEGIN {
	use config;
	use Exporter ();
	use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
	$VERSION = 1.00; @ISA = qw(Exporter);	%EXPORT_TAGS = (); @EXPORT_OK = ();
	@EXPORT = qw(&log_printf &log_put &log_set &error_printf $logremote &set_log_prefix &get_log_prefix &log_hash &assert);

	$logfname = $cfg{'logfname'};
	$logremote = '';
	$oldvia = '';
	$oldreferer = '';
	$prefix = ' ';
}

sub set_log_prefix ($) { if ($_[0] ne '') { $prefix = $_[0].': '; } else { $prefix = ' '; } }
sub get_log_prefix () { return $prefix; }

sub getlogdate { 
	my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
	my($test);

	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime(time());
	$test=sprintf("%02d/%02d/%4d %02d:%02d:%02d", $mday,$mon+1,$year+1900,$hour,$min,$sec);
	return $test;
}

sub assert ($) {
	my ($p) = @_;
	my ($package, $filename, $line, $subroutine) = caller(0);
	$subroutine = (caller(1))[3];
	if (!$p) {
		&log_put("!assert $package:$filename:$line sub $subroutine");
	}
	return $p;
}

sub log_put {
	open LOGF, ">>$logfname";
	binmode LOGF;
	if ($ENV{'HTTP_REFERER'} ne $oldreferer) {
		print LOGF &getlogdate()." $logremote"."[$$]:${prefix}HTTP_REFERER=",$ENV{'HTTP_REFERER'},"\n";
		$oldreferer = $ENV{'HTTP_REFERER'};
	}
	if ($ENV{'HTTP_VIA'} ne $oldvia) {
		print LOGF &getlogdate()." $logremote"."[$$]:${prefix}HTTP_VIA=",$ENV{'HTTP_VIA'},"\n";
		$oldvia = $ENV{'HTTP_VIA'};
	}
	print LOGF &getlogdate()." $logremote"."[$$]:$prefix",@_,"\n";
	close LOGF;
}

sub log_set {
	my ($fname) = @_;
	$logfname = $fname if ($fname ne '');
}

sub log_printf { &log_put($#_>0?sprintf(@_):$_[0]); }

sub error_printf { &log_put('Error:'.($#_>0?sprintf(@_):$_[0])); }

sub log_hash ($$)
{
	my ($hash, $name) = @_;

	foreach my $i (keys %$hash) {
		&log_put("HASH $name: '$i' = '".$hash->{$i}."'");
	}
}

1;

