/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestXML {
    private IProject project;
    private ICompletionProposal[] proposals;

    @BeforeEach
    public void setUpProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
    }

    @Test
    public void testXMLFile() throws Exception {
        final IFile file = this.project.getFile("blah.xml");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<plugin></");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testXSLFile() throws Exception {
        final IFile file = this.project.getFile("blah.xsl");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testXSDFile() throws Exception {
        final IFile file = this.project.getFile("blah.xsd");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testDTDFile() throws Exception {
        final IFile file = this.project.getFile("blah.dtd");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<!--<!-- -->");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testComplexXML() throws Exception {
        IFile file = this.project.getFile("blah.xml");
        String content = "<layout:BlockLayoutCell\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\t\n    xsi:schemaLocation=\"sap.ui.layout https://openui5.hana.ondemand.com/downloads/schemas/sap.ui.layout.xsd\"\n\txmlns:layout=\"sap.ui.layout\">\n    |\n</layout:BlockLayoutCell>";
        int offset = content.indexOf(124);
        content = content.replace("|", "");
        file.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
        AbstractTextEditor editor = (AbstractTextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (String)"org.eclipse.ui.genericeditor.GenericEditor");
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, 0));
        LSContentAssistProcessor processor = new LSContentAssistProcessor();
        this.proposals = processor.computeCompletionProposals((ITextViewer)Utils.getViewer(editor), offset);
        DisplayHelper.sleep((Display)editor.getSite().getShell().getDisplay(), (long)2000L);
        Assertions.assertTrue((this.proposals.length > 1 ? 1 : 0) != 0);
    }

    @Test
    public void autoCloseTags() throws Exception {
        IFile file = this.project.getFile("autoCloseTags.xml");
        file.create((InputStream)new ByteArrayInputStream("<foo".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        final IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.replace(4, 0, ">");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return "<foo></foo>".equals(document.get());
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Autoclose not done");
    }
}

