/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.eval.problem.ILowvisionProblemSubtype;
import org.eclipse.actf.visualization.internal.engines.lowvision.PageElement;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionRecommendation;
import org.w3c.dom.Element;

public abstract class LowVisionProblem
implements ILowvisionProblemSubtype {
    public static final int UNSET_POSITION = -1;
    public static final int DEFAULT_PRIORITY = 0;
    public static final short LOWVISION_PROBLEM = 0;
    IPageImage pageImage = null;
    LowVisionType lowVisionType = null;
    int problemType;
    short componentType = (short)-1;
    PageComponent pageComponent = null;
    PageElement pageElement = null;
    String description;
    int left = -1;
    int top = -1;
    int width = 0;
    int height = 0;
    int priority;
    double probability = 0.0;
    double characterScore = 0.0;
    int numRecommendations = 0;
    LowVisionRecommendation[] recommendations = null;
    boolean isGroupFlag = false;
    Element element;
    private static final int[] PROBLEM_COLORS = new int[]{0xFFFFFF, 0xFF0000, 65280};

    protected LowVisionProblem() {
    }

    public LowVisionProblem(int n, LowVisionType lowVisionType, String string, PageComponent pageComponent, double d) throws LowVisionProblemException {
        this.problemType = n;
        this.lowVisionType = lowVisionType;
        this.description = string;
        this.pageComponent = pageComponent;
        this.componentType = this.pageComponent.getType();
        this.pageImage = this.pageComponent.getPageImage();
        ConnectedComponent connectedComponent = this.pageComponent.getConnectedComponent();
        if (connectedComponent != null) {
            this.left = connectedComponent.getLeft();
            this.top = connectedComponent.getTop();
            this.width = connectedComponent.getWidth();
            this.height = connectedComponent.getHeight();
        }
        this.setPriority();
        this.probability = d;
        this.characterScore = this.probability * (double)this.width * (double)this.height;
    }

    public LowVisionProblem(int n, LowVisionType lowVisionType, String string, PageElement pageElement, double d) {
        this.problemType = n;
        this.lowVisionType = lowVisionType;
        this.description = string;
        this.pageElement = pageElement;
        if (this.pageElement != null) {
            this.left = this.pageElement.getX();
            this.top = this.pageElement.getY();
            this.width = this.pageElement.getWidth();
            this.height = this.pageElement.getHeight();
        }
        this.setPriority();
        this.probability = d;
    }

    private void setPriority() {
        this.priority = this.left == -1 || this.top == -1 ? 0 : Integer.MAX_VALUE - this.top * 65535 - this.left;
    }

    protected abstract void setRecommendations() throws LowVisionProblemException;

    public short getType() {
        return 0;
    }

    public LowVisionType getLowVisionType() {
        return this.lowVisionType;
    }

    public int getLowVisionProblemType() {
        return this.problemType;
    }

    public String getDescription() throws LowVisionProblemException {
        return this.description;
    }

    public IPageImage getPageImage() {
        return this.pageImage;
    }

    public int getX() {
        return this.left;
    }

    public int getY() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPriority() {
        return this.priority;
    }

    public double getProbability() {
        return this.probability;
    }

    public int getIntProbability() {
        return (int)Math.rint(this.probability * 100.0);
    }

    public double getCharacterScore() {
        return this.characterScore;
    }

    public LowVisionRecommendation[] getRecommendations() {
        return this.recommendations;
    }

    public boolean isGroup() {
        return this.isGroupFlag;
    }

    public short getComponentType() throws LowVisionProblemException {
        if (!this.isGroupFlag) {
            return this.componentType;
        }
        throw new LowVisionProblemException("componentType cannot be gotten from a ProblemGroup.");
    }

    public PageComponent getPageComponent() throws LowVisionProblemException {
        if (!this.isGroupFlag) {
            return this.pageComponent;
        }
        throw new LowVisionProblemException("component cannot be gotten from a ProblemGroup.");
    }

    public PageElement getPageElement() {
        return this.pageElement;
    }

    public String toString() {
        String string = null;
        string = this.componentType == 4 ? "(SS)" : (this.componentType == 5 ? "(MS)" : (this.componentType == 6 ? "(SM)" : "" + this.componentType));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Description=" + this.description);
        stringBuffer.append(string);
        stringBuffer.append(", ");
        stringBuffer.append("(x,y)=(" + this.left + "," + this.top + ")");
        stringBuffer.append(", ");
        stringBuffer.append("[WIDTH x HEIGHT]=[" + this.width + " x " + this.height + "]");
        stringBuffer.append(", ");
        stringBuffer.append("Probability=" + (int)Math.rint(this.probability * 100.0));
        stringBuffer.append(", ");
        stringBuffer.append("#Recommendations=" + this.numRecommendations);
        return stringBuffer.toString();
    }

    public void dump(PrintStream printStream, boolean bl) throws LowVisionProblemException {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter, bl);
    }

    public void dump(PrintWriter printWriter, boolean bl) throws LowVisionProblemException {
        printWriter.println("----------");
        printWriter.println("dumping a problem");
        printWriter.println("problemType = " + this.problemType);
        printWriter.println("componentType = " + this.componentType);
        printWriter.println("description = " + this.getDescription());
        printWriter.println("(x,y) = ( " + this.getX() + ", " + this.getY() + ")");
        printWriter.println("width, height = " + this.getWidth() + ", " + this.getHeight());
        printWriter.println("priority = " + this.getPriority());
        LowVisionRecommendation[] lowVisionRecommendationArray = this.getRecommendations();
        if (lowVisionRecommendationArray != null) {
            printWriter.println("# of Recommendations = " + lowVisionRecommendationArray.length);
        } else {
            printWriter.println("Recommendations are null.");
        }
        if (bl && lowVisionRecommendationArray != null) {
            int n = 0;
            while (n < lowVisionRecommendationArray.length) {
                printWriter.println("Recommendation #" + n);
                lowVisionRecommendationArray[n].dump(printWriter);
                ++n;
            }
        }
        printWriter.println("----------");
    }

    public void drawSurroundingBox(Int2D int2D) {
        int n = this.getX();
        int n2 = this.getY();
        int n3 = n + this.getWidth();
        int n4 = n2 + this.getHeight();
        int n5 = PROBLEM_COLORS[this.problemType];
        int n6 = n;
        while (n6 < n3) {
            int2D.getData()[n2][n6] = n5;
            int2D.getData()[n4 - 1][n6] = n5;
            ++n6;
        }
        n6 = n2;
        while (n6 < n4) {
            int2D.getData()[n6][n] = n5;
            int2D.getData()[n6][n3 - 1] = n5;
            ++n6;
        }
    }

    public static void drawAllSurroundingBoxes(LowVisionProblem[] lowVisionProblemArray, Int2D int2D) {
        int n = 0;
        while (n < lowVisionProblemArray.length) {
            lowVisionProblemArray[n].drawSurroundingBox(int2D);
            ++n;
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }
}

