/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.incquery.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.sphinx.emf.incquery.IIncQueryEngineHelper;
import org.eclipse.sphinx.emf.incquery.IMatcherProvider;
import org.eclipse.sphinx.emf.incquery.IncQueryEngineHelper;
import org.eclipse.sphinx.emf.incquery.internal.Activator;
import org.eclipse.sphinx.emf.query.IModelQueryService;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractModelQueryService
implements IModelQueryService {
    private List<IMatcherProvider> matcherProviders = new ArrayList<IMatcherProvider>();
    private IIncQueryEngineHelper incQueryEngineHelper;

    public AbstractModelQueryService() {
        this.initMatcherProviders();
    }

    protected abstract void initMatcherProviders();

    protected List<IMatcherProvider> getMatcherProviders() {
        if (this.matcherProviders == null) {
            this.matcherProviders = new ArrayList<IMatcherProvider>();
        }
        return this.matcherProviders;
    }

    protected IIncQueryEngineHelper getIncQueryEngineHelper() {
        if (this.incQueryEngineHelper == null) {
            this.incQueryEngineHelper = this.createIncQueryEngineHelper();
        }
        return this.incQueryEngineHelper;
    }

    protected IIncQueryEngineHelper createIncQueryEngineHelper() {
        return new IncQueryEngineHelper();
    }

    protected <T> IMatcherProvider getMatcherProvider(Class<T> type) {
        for (IMatcherProvider provider : this.matcherProviders) {
            if (!provider.isProviderForType(type)) continue;
            return provider;
        }
        return null;
    }

    public <T> List<T> getAllInstancesOf(EObject contextObject, Class<T> type) {
        return this.getAllInstancesOf(contextObject.eResource(), type);
    }

    public <T> List<T> getAllInstancesOf(Resource contextResource, Class<T> type) {
        ArrayList result = new ArrayList();
        try {
            IMatcherProvider provider = this.getMatcherProvider(type);
            if (provider != null) {
                IncQueryMatcher matcher = provider.getMatcher(this.getIncQueryEngineHelper().getEngine(contextResource), type);
                Set allValues = matcher.getAllValues((String)matcher.getParameterNames().get(0));
                for (Object val : allValues) {
                    result.add(val);
                }
            }
        }
        catch (IncQueryException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
        return result;
    }
}

