/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.uml2.diagram.common.commands.RequiredPortLinkHelper;
import org.eclipse.uml2.diagram.csd.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;

public class PortRequiredReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;
    private final RequiredPortLinkHelper myLinkHelper;

    public PortRequiredReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
        this.myLinkHelper = new RequiredPortLinkHelper((AdapterFactoryEditingDomain)this.getEditingDomain(), this.referenceOwner, this.oldEnd);
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Port)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSourceGen() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Port)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistPortRequired_4014(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientSource() {
        return this.canReorientSourceGen() && this.myLinkHelper.canReorientSource(this.getNewSource());
    }

    protected boolean canReorientTargetGen() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Interface)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistPortRequired_4014(this.getOldSource(), this.getNewTarget());
    }

    protected boolean canReorientTarget() {
        return this.canReorientTargetGen() && this.myLinkHelper.canReorientTarget(this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.myLinkHelper.reorientSource(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.myLinkHelper.reorientTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Port getOldSource() {
        return (Port)this.referenceOwner;
    }

    protected Port getNewSource() {
        return (Port)this.newEnd;
    }

    protected Interface getOldTarget() {
        return (Interface)this.oldEnd;
    }

    protected Interface getNewTarget() {
        return (Interface)this.newEnd;
    }
}

