/* Generated By:JavaCC: Do not edit this line. OperationParser.java */
/*
 * Copyright (c) 2006 Borland Software Corporation
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael Golubev (Borland) - initial API and implementation
 */
package org.eclipse.uml2.diagram.common.parser.operation;

import java.io.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.diagram.parser.*;
import org.eclipse.uml2.diagram.parser.lookup.LookupSuite;
import org.eclipse.uml2.uml.*;

/**
 * JavaCC does not support any "include" construct. 
 * This parser shares a lot of delcrations (mainly at the tokens level) 
 * with other parsers (see PropertyParser, etc)
 * but we do not yet know how to avoid duplication of the delarations. 
 */
public class OperationParser extends ExternalParserBase implements OperationParserConstants {
        private OperationAdapter myOperation;
        private ParameterAdapter myCurrentParameter;

        private static interface TypeGate {
                public void setType(Type type);
                public void setName(String name);
        }

        private static interface MultiplicityGate {
                public void setIsOrdered(boolean ordered);
                public void setIsUnique(boolean unique);
                public void setLower(int lower);
                public void setUpper(int upper);
        }

        private static class ParameterAdapter implements TypeGate, MultiplicityGate {
                private final Parameter myParameter;

                public ParameterAdapter(){
                        myParameter = UMLFactory.eINSTANCE.createParameter();
                }

                public Parameter getParameter(){
                        return myParameter;
                }

                public void setType(Type type){
                        myParameter.setType(type);
                }

                public void setName(String name){
                        myParameter.setName(name);
                }

                public void setIsOrdered(boolean value) {
                        myParameter.setIsOrdered(value);
                }

                public void setIsUnique(boolean value) {
                        myParameter.setIsUnique(value);
                }

                public void setLower(int value) {
                        myParameter.setLower(value);
                }

                public void setUpper(int value) {
                        myParameter.setUpper(value);
                }
        }

        private static class OperationAdapter implements TypeGate, MultiplicityGate {
                private final Operation myOperation;

                public OperationAdapter(Operation operation){
                        myOperation = operation;
                        if (myOperation.getReturnResult() == null){
                                myOperation.createReturnResult(null, null);
                        }
                }

                public Operation getOperation(){
                        return myOperation;
                }

                public void setType(Type type) {
                        myOperation.setType(type);
                }

                public void setName(String name){
                        myOperation.setName(name);
                }

                public void setIsOrdered(boolean ordered) {
                        myOperation.setIsOrdered(ordered);
                }

                public void setIsUnique(boolean value) {
                        myOperation.setIsUnique(value);
                }

                public void setLower(int value) {
                        myOperation.setLower(value);
                }

                public void setUpper(int value) {
                        myOperation.setUpper(value);
                }

        }

    public OperationParser(){
        this(new StringReader("")); //$NON-NLS-1$
    }

    public OperationParser(LookupSuite lookup){
        this();
        setLookupSuite(lookup);
    }

        public EClass getSubjectClass(){
                return UMLPackage.eINSTANCE.getOperation();
        }

        public void parse(EObject target, String text) throws ExternalParserException {
                checkContext();
                ReInit(new StringReader(text));
                myOperation = new OperationAdapter((Operation)target);
                myCurrentParameter = null;
                Declaration();
                myOperation = null;
        }

        protected static int parseInt(Token t) throws ParseException {
                if (t.kind != OperationParserConstants.INTEGER_LITERAL){
                        throw new IllegalStateException("Token: " + t + ", image: " + t.image); //$NON-NLS-1$ //$NON-NLS-2$
                }
                try {
                        return Integer.parseInt(t.image); //XXX: "0005", "99999999999999999999999"
                } catch (NumberFormatException e){
                        throw new ParseException("Not supported integer value:" + t.image); //$NON-NLS-1$
                }
        }

        private MultiplicityGate getCurrentMultiplicityElement(){
                return myCurrentParameter != null ? myCurrentParameter : (MultiplicityGate)myOperation;
        }

        private TypeGate getCurrentTypedElement(){
                return myCurrentParameter != null ? myCurrentParameter : (TypeGate)myOperation;
        }

        private Operation getOperation(){
                return myOperation.getOperation();
        }

        private Parameter getCurrentParameter(){
                if (myCurrentParameter == null){
                        throw new IllegalStateException("We are not in the parameter list. Check BNF"); //$NON-NLS-1$
                }
                return myCurrentParameter.getParameter();
        }

        private void registerParameter() {
                getOperation().getOwnedParameters().add(getCurrentParameter());
                myCurrentParameter = null;
        }

        private void startParameter() {
                myCurrentParameter = new ParameterAdapter();
        }

  final public void Declaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
    case NUMBER_SIGN:
    case TILDE:
      Visibility();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    Name();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
    case OUT:
    case IN_OUT:
    case IDENTIFIER:
      ParametersList();
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      Type();
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LCURLY:
      OperationModifiers();
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    jj_consume_token(0);
  }

  final public void ParametersList() throws ParseException {
    Parameter();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_1;
      }
      jj_consume_token(COMMA);
      Parameter();
    }
  }

  final public void Parameter() throws ParseException {
        startParameter();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
    case OUT:
    case IN_OUT:
      ParameterDirection();
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    Name();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      Type();
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      Multiplicity();
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUALS:
      DefaultValue();
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
                registerParameter();
  }

  final public void ParameterDirection() throws ParseException {
        ParameterDirectionKind kind;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
      jj_consume_token(IN);
                       kind = ParameterDirectionKind.IN_LITERAL;
      break;
    case OUT:
      jj_consume_token(OUT);
                        kind = ParameterDirectionKind.OUT_LITERAL;
      break;
    case IN_OUT:
      jj_consume_token(IN_OUT);
                           kind = ParameterDirectionKind.INOUT_LITERAL;
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                getCurrentParameter().setDirection(kind);
  }

  final public void Visibility() throws ParseException {
        VisibilityKind kind;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
                         kind = VisibilityKind.PUBLIC_LITERAL;
      break;
    case MINUS:
      jj_consume_token(MINUS);
                          kind = VisibilityKind.PRIVATE_LITERAL;
      break;
    case NUMBER_SIGN:
      jj_consume_token(NUMBER_SIGN);
                                kind = VisibilityKind.PROTECTED_LITERAL;
      break;
    case TILDE:
      jj_consume_token(TILDE);
                          kind = VisibilityKind.PACKAGE_LITERAL;
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                getOperation().setVisibility(kind);
  }

  final public void Name() throws ParseException {
        String name;
    name = NameWithSpaces();
                getCurrentTypedElement().setName(name);
  }

  final public void Multiplicity() throws ParseException {
    MultiplicityRange();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LCURLY:
      MultiplicityDesignator();
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
  }

  final public void MultiplicityDesignator() throws ParseException {
    jj_consume_token(LCURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNIQUE:
    case NON_UNIQUE:
      MultiplicityUnique();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ORDERED:
      case UNORDERED:
        MultiplicityOrdered();
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      break;
    case ORDERED:
    case UNORDERED:
      MultiplicityOrdered();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNIQUE:
      case NON_UNIQUE:
        MultiplicityUnique();
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RCURLY);
  }

  final public void MultiplicityUnique() throws ParseException {
        MultiplicityGate multiplicity = getCurrentMultiplicityElement();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNIQUE:
      jj_consume_token(UNIQUE);
                           multiplicity.setIsUnique(true);
      break;
    case NON_UNIQUE:
      jj_consume_token(NON_UNIQUE);
                               multiplicity.setIsUnique(false);
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void MultiplicityOrdered() throws ParseException {
        MultiplicityGate multiplicity = getCurrentMultiplicityElement();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDERED:
      jj_consume_token(ORDERED);
                            multiplicity.setIsOrdered(true);
      break;
    case UNORDERED:
      jj_consume_token(UNORDERED);
                              multiplicity.setIsOrdered(false);
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* XXX: ValueSpecification -- how to parse */
  final public void MultiplicityRange() throws ParseException {
        Token tLower = null;
        Token tUpper;
        MultiplicityGate multiplicity = getCurrentMultiplicityElement();
    jj_consume_token(LBRACKET);
    if (jj_2_1(2)) {
      tLower = jj_consume_token(INTEGER_LITERAL);
      jj_consume_token(DOT);
      jj_consume_token(DOT);
                                                                        multiplicity.setLower(parseInt(tLower));
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      tUpper = jj_consume_token(STAR);
                                if (tLower == null){
                                        multiplicity.setLower(0);
                                }
                                multiplicity.setUpper(LiteralUnlimitedNatural.UNLIMITED);
      break;
    case INTEGER_LITERAL:
      tUpper = jj_consume_token(INTEGER_LITERAL);
                                if (tLower == null){
                                        multiplicity.setLower(parseInt(tUpper));
                                }
                                multiplicity.setUpper(parseInt(tUpper));
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACKET);
  }

  final public void Type() throws ParseException {
        String type;
    jj_consume_token(COLON);
    type = NameWithSpaces();
                                          getCurrentTypedElement().setType(lookup(Type.class, type));
  }

  final public String NameWithSpaces() throws ParseException {
        StringBuffer result = new StringBuffer();
        Token t;
    t = jj_consume_token(IDENTIFIER);
                                   result.append(t.image);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_2;
      }
      t = jj_consume_token(IDENTIFIER);
                                     result.append(' '); result.append(t.image);
    }
                {if (true) return result.toString();}
    throw new Error("Missing return statement in function"); //$NON-NLS-1$
  }

  final public void DefaultValue() throws ParseException {
        Token t;
    jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      t = jj_consume_token(IDENTIFIER);
      break;
    case INTEGER_LITERAL:
      t = jj_consume_token(INTEGER_LITERAL);

      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                getCurrentParameter().setDefault(t.image);
  }

  final public void SimpleTokenPropertyModifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUERY:
      jj_consume_token(QUERY);
                          getOperation().setIsQuery(true);
      break;
    case ORDERED:
      jj_consume_token(ORDERED);
                            getOperation().setIsOrdered(true);
      break;
    case UNORDERED:
      jj_consume_token(UNORDERED);
                              getOperation().setIsOrdered(false);
      break;
    case UNIQUE:
      jj_consume_token(UNIQUE);
                           getOperation().setIsUnique(true);
      break;
    case NON_UNIQUE:
      jj_consume_token(NON_UNIQUE);
                               getOperation().setIsUnique(false);
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ReferencingPropertyModifier() throws ParseException {
        String name;
    jj_consume_token(REDEFINES);
    name = NameWithSpaces();
                RedefinableElement redefines = lookup(RedefinableElement.class, name);
                if (redefines != null) {
                        getOperation().getRedefinedElements().add(redefines);
                }
  }

  final public void OperationModifiers() throws ParseException {
    jj_consume_token(LCURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDERED:
    case UNORDERED:
    case UNIQUE:
    case NON_UNIQUE:
    case QUERY:
      SimpleTokenPropertyModifier();
      break;
    case REDEFINES:
      ReferencingPropertyModifier();
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[22] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ORDERED:
      case UNORDERED:
      case UNIQUE:
      case NON_UNIQUE:
      case QUERY:
        SimpleTokenPropertyModifier();
        break;
      case REDEFINES:
        ReferencingPropertyModifier();
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RCURLY);
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  public OperationParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[24];
  static private int[] jj_la1_0;
  static {
      jj_la1_0();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x1e000,0x2e000000,0x10,0x100,0x1000,0xe000000,0x10,0x40,0x20,0xe000000,0x1e000,0x100,0x300000,0xc00000,0xf00000,0xc00000,0x300000,0x10040000,0x20000000,0x30000000,0x1f00000,0x1f80000,0x1000,0x1f80000,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public OperationParser(java.io.InputStream stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new OperationParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public OperationParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new OperationParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public OperationParser(OperationParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(OperationParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[32];
    for (int i = 0; i < 32; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 24; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 32; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
