/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.ui.newproject;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class NewProjectInfo {
    private String projectName;
    private Map otherInfo = null;
    private static final String NL = System.getProperty("line.separator");
    private static final String INDENT = "    ";
    private String location = null;

    public final String getProjectName() {
        return this.projectName;
    }

    public final void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String toXmlString() {
        if (this.projectName == null) {
            throw new IllegalStateException("projectName not set");
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<newProjectModel>").append(NL);
        xml.append(INDENT).append("<project");
        this.addAttribute(xml, "name", this.projectName);
        this.addAttribute(xml, "location", this.location);
        xml.append("/>").append(NL);
        if (this.otherInfo != null) {
            Iterator i = this.otherInfo.values().iterator();
            while (i.hasNext()) {
                String otherElement = (String)i.next();
                xml.append(INDENT).append(otherElement).append(NL);
            }
        }
        xml.append("</newProjectModel>").append(NL);
        return xml.toString();
    }

    private void addAttribute(StringBuffer xml, String name, String value) {
        if (value != null) {
            xml.append(' ').append(name).append("=\"").append(value).append("\"");
        }
    }

    public void setOtherInfo(String key, String xmlContent) {
        if (this.otherInfo == null) {
            this.otherInfo = new LinkedHashMap();
        }
        if (xmlContent != null) {
            this.otherInfo.put(key, xmlContent);
        } else {
            this.otherInfo.remove(key);
        }
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

