/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.core.parser.ITagLibraryResolver;
import org.eclipse.jet.internal.taglib.TagLibraryReferenceImpl;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.taglib.TagLibraryReference;

public class TagLibraryUsageManager {
    private final Map tagLibraries = new HashMap();
    private final Map predefinedLibraryMap;
    private List tags = null;
    private final ITagLibraryResolver tagLibraryResolver;

    public TagLibraryUsageManager(Map predefinedLibraryMap, ITagLibraryResolver tagLibraryResolver) {
        this.tagLibraryResolver = tagLibraryResolver;
        this.predefinedLibraryMap = new HashMap(predefinedLibraryMap);
    }

    public boolean canDefinePrefix(String prefix, String id) {
        if (!this.tagLibraries.containsKey(prefix) && !this.predefinedLibraryMap.containsKey(prefix)) {
            return true;
        }
        return id.equals(this.predefinedLibraryMap.get(prefix));
    }

    public boolean isLibraryDefined(String libaryId) {
        return this.tagLibraries.containsValue(libaryId);
    }

    public String getLibraryIdFromPrefix(String prefix) {
        String id = (String)this.tagLibraries.get(prefix);
        if (id == null) {
            id = (String)this.predefinedLibraryMap.get(prefix);
        }
        return id;
    }

    public void add(String prefix, String libraryId) {
        this.tagLibraries.put(prefix, libraryId);
        Iterator i = this.predefinedLibraryMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!libraryId.equals(entry.getValue())) continue;
            i.remove();
        }
        this.tags = null;
    }

    public TagDefinition getTagDefinition(String tagName) {
        int sepIndex = tagName.indexOf(58);
        String prefix = sepIndex == -1 ? "" : tagName.substring(0, sepIndex);
        String tagNCName = sepIndex == -1 ? tagName : tagName.substring(sepIndex + 1);
        String id = this.getLibraryIdFromPrefix(prefix.toLowerCase());
        TagLibrary tagLibrary = this.tagLibraryResolver.getLibrary(id);
        return tagLibrary.getTagDefinition(tagNCName);
    }

    public boolean isKnownTag(String tagName) {
        TagLibrary tagLibrary;
        boolean knownTag = false;
        int sepIndex = tagName.indexOf(58);
        String prefix = sepIndex == -1 ? "" : tagName.substring(0, sepIndex);
        String tagNCName = sepIndex == -1 ? tagName : tagName.substring(sepIndex + 1);
        String id = this.getLibraryIdFromPrefix(prefix.toLowerCase());
        if (id != null && (tagLibrary = this.tagLibraryResolver.getLibrary(id)) != null) {
            knownTag = tagLibrary.hasTag(tagNCName);
        }
        return knownTag;
    }

    public boolean isKnownInvalidTagName(String tagName) {
        TagLibrary tagLibrary;
        boolean knownInvalidTagName = false;
        int sepIndex = tagName.indexOf(58);
        String prefix = sepIndex == -1 ? "" : tagName.substring(0, sepIndex);
        String tagNCName = sepIndex == -1 ? tagName : tagName.substring(sepIndex + 1);
        String id = this.getLibraryIdFromPrefix(prefix.toLowerCase());
        if (id != null && (tagLibrary = this.tagLibraryResolver.getLibrary(id)) != null && prefix.length() > 0) {
            knownInvalidTagName = !tagLibrary.hasTag(tagNCName);
        }
        return knownInvalidTagName;
    }

    public TagLibraryReference[] getTagLibraryReferences() {
        Map.Entry entry;
        ArrayList<TagLibraryReferenceImpl> result = new ArrayList<TagLibraryReferenceImpl>(this.predefinedLibraryMap.size() + this.tagLibraries.size());
        Iterator i = this.predefinedLibraryMap.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            result.add(new TagLibraryReferenceImpl((String)entry.getKey(), (String)entry.getValue(), true));
        }
        i = this.tagLibraries.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            result.add(new TagLibraryReferenceImpl((String)entry.getKey(), (String)entry.getValue(), false));
        }
        return result.toArray(new TagLibraryReference[result.size()]);
    }

    public String[] getKnownTagNames() {
        ArrayList<String> localTags = this.tags;
        if (localTags == null) {
            localTags = new ArrayList<String>();
            Iterator i = this.tagLibraries.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String prefix = (String)entry.getKey();
                String id = (String)entry.getValue();
                TagLibrary tagLibrary = this.tagLibraryResolver.getLibrary(id);
                String[] tagNames = tagLibrary.getTagNames();
                int j = 0;
                while (j < tagNames.length) {
                    localTags.add(String.valueOf(prefix) + "." + tagNames[j]);
                    ++j;
                }
            }
        }
        return localTags.toArray(new String[localTags.size()]);
    }
}

