/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.wizards;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.util.IDEEditorUtil;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.EditorUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public abstract class EditorWizardPage
extends WizardNewFileCreationPage {
    protected final IWorkbench workbench;
    private final IStructuredSelection selection;
    protected IFile diagramFile;
    protected boolean openNewlyCreatedDiagramEditor;

    public EditorWizardPage(String pageName, IWorkbench aWorkbench, IStructuredSelection selection) {
        super(pageName, selection);
        this.workbench = aWorkbench;
        this.selection = selection;
        this.diagramFile = null;
        this.openNewlyCreatedDiagramEditor = true;
    }

    public boolean doFinish(IProgressMonitor monitor) {
        this.diagramFile = this.createAndOpenDiagram(this.getContainerFullPath(), this.getFileName(), this.getInitialContents(), this.getDiagramKind(), this.workbench.getActiveWorkbenchWindow(), monitor, true);
        return this.diagramFile != null;
    }

    public IFile createAndOpenDiagram(IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean saveDiagram) {
        return IDEEditorUtil.createAndOpenDiagram(this.getDiagramFileCreator(), containerPath, fileName, initialContents, kind, dWindow, progressMonitor, this.isOpenNewlyCreatedDiagramEditor(), saveDiagram);
    }

    public boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public boolean finish() {
        final boolean[] result = new boolean[1];
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                result[0] = EditorWizardPage.this.doFinish(monitor);
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)EditorMessages.EditorWizardPage_DialogInternalErrorTitle, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                Trace.catching((Plugin)EditorPlugin.getInstance(), (String)EditorDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"finish", (Throwable)e.getTargetException());
                Log.error((Plugin)EditorPlugin.getInstance(), (int)1, (String)EditorMessages.WizardPage_DIAGRAM_CREATION_FAIL_EXC_, (Throwable)e.getTargetException());
            }
            return false;
        }
        return result[0];
    }

    public final IFile getDiagramFile() {
        return this.diagramFile;
    }

    protected String getDefaultFileName() {
        return null;
    }

    public abstract DiagramFileCreator getDiagramFileCreator();

    protected String getDiagramKind() {
        return null;
    }

    protected InputStream getInitialContents() {
        return EditorUtil.getInitialContents();
    }

    public String getFileName() {
        String fileName = super.getFileName();
        if (fileName != null) {
            fileName = this.getDiagramFileCreator().appendExtensionToFileName(fileName);
        }
        return fileName;
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String fileName = this.getFileName();
            if (fileName == null) {
                return false;
            }
            IPath path = this.getContainerFullPath().append(fileName);
            if (ResourcesPlugin.getWorkspace().getRoot().exists(path)) {
                this.setErrorMessage(EditorMessages.WizardPage_Message_FileExists_ERROR_);
                return false;
            }
            URI fileURI = URI.createFileURI((String)path.toString());
            String ext = fileURI.fileExtension();
            if (ext != null && this.getDiagramFileCreator().getExtension().equals("." + ext)) {
                return true;
            }
            this.setErrorMessage(NLS.bind((String)EditorMessages.EditorWizardPage_InvalidFilename, (Object)fileName));
        }
        return false;
    }

    public final IStructuredSelection getSelection() {
        return this.selection;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IPath path = this.getContainerFullPath();
        if (path != null) {
            String fileName = this.getDiagramFileCreator().getUniqueFileName(path, this.getDefaultFileName());
            this.setFileName(fileName);
        }
        this.setPageComplete(this.validatePage());
    }

    protected void initialPopulateContainerNameField() {
        IPath path = EditorUtil.getDefaultDiagramPath((List)this.selection.toList(), (String)this.getDiagramKind());
        if (path == null) {
            super.initialPopulateContainerNameField();
            path = this.getContainerFullPath();
            if (path == null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject[] projects = root.getProjects();
                path = root.getFullPath();
                int i = 0;
                while (i < projects.length) {
                    IProject project = projects[i];
                    if (project.isOpen()) {
                        path = project.getFullPath();
                        break;
                    }
                    ++i;
                }
            }
        }
        this.setContainerFullPath(path);
    }
}

