/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.notation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class Smoothness
extends AbstractEnumerator {
    public static final int NONE = 0;
    public static final int NORMAL = 1;
    public static final int LESS = 2;
    public static final int MORE = 3;
    public static final Smoothness NONE_LITERAL = new Smoothness(0, "None", "None");
    public static final Smoothness NORMAL_LITERAL = new Smoothness(1, "Normal", "Normal");
    public static final Smoothness LESS_LITERAL = new Smoothness(2, "Less", "Less");
    public static final Smoothness MORE_LITERAL = new Smoothness(3, "More", "More");
    private static final Smoothness[] VALUES_ARRAY = new Smoothness[]{NONE_LITERAL, NORMAL_LITERAL, LESS_LITERAL, MORE_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static Smoothness get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Smoothness result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Smoothness getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Smoothness result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Smoothness get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return NORMAL_LITERAL;
            }
            case 2: {
                return LESS_LITERAL;
            }
            case 3: {
                return MORE_LITERAL;
            }
        }
        return null;
    }

    private Smoothness(int value, String name, String literal) {
        super(value, name, literal);
    }
}

