/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.core.internal.command;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;

public class FileModificationApproverTest
extends TestCase {
    private IOperationHistory history;
    private IProject project;
    private IFile file;

    public static void main(String[] args) {
        TestRunner.run((Test)FileModificationApproverTest.suite());
    }

    public static Test suite() {
        return new TestSuite(FileModificationApproverTest.class);
    }

    public FileModificationApproverTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.history = OperationHistoryFactory.getOperationHistory();
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            this.project = root.getProject("FileModificationApproverTest");
            this.project.create(null);
            this.project.open(null);
            this.file = this.project.getFile("test.txt");
            ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
            this.file.create((InputStream)contents, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.project.close((IProgressMonitor)new NullProgressMonitor());
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = null;
        this.file = null;
        this.history = null;
    }

    private void fail(Exception e) {
        e.printStackTrace();
        FileModificationApproverTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
    }

    public void test_execute_undo_redo() {
        TestCommand c = new TestCommand("test_execute_undo_redo", Collections.singletonList(this.file));
        UndoContext ctx = new UndoContext();
        c.addContext((IUndoContext)ctx);
        ResourceAttributes attributes = this.file.getResourceAttributes();
        try {
            attributes.setReadOnly(true);
            this.file.setResourceAttributes(attributes);
            this.history.execute((IUndoableOperation)c, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        c.assertNotExecuted();
        c.reset();
        try {
            attributes.setReadOnly(false);
            this.file.setResourceAttributes(attributes);
            this.history.execute((IUndoableOperation)c, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        c.assertExecuted();
        c.reset();
        try {
            attributes.setReadOnly(true);
            this.file.setResourceAttributes(attributes);
            FileModificationApproverTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        c.assertNotUndone();
        c.reset();
        try {
            attributes.setReadOnly(false);
            this.file.setResourceAttributes(attributes);
            FileModificationApproverTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        c.assertUndone();
        c.reset();
        try {
            attributes.setReadOnly(true);
            this.file.setResourceAttributes(attributes);
            FileModificationApproverTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        c.assertNotRedone();
        c.reset();
        try {
            attributes.setReadOnly(false);
            this.file.setResourceAttributes(attributes);
            FileModificationApproverTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        c.assertRedone();
        c.reset();
    }

    protected static class TestCommand
    extends AbstractCommand {
        private static final String EXECUTED = "executed";
        private static final String UNDONE = "undone";
        private static final String REDONE = "redone";
        private boolean executed;
        private boolean undone;
        private boolean redone;

        public TestCommand(String label, List affectedFiles) {
            super(label, affectedFiles);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = true;
            this.undone = false;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)EXECUTED);
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = false;
            this.undone = false;
            this.redone = true;
            return CommandResult.newOKCommandResult((Object)REDONE);
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = false;
            this.undone = true;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)UNDONE);
        }

        public void assertExecuted() {
            FileModificationApproverTest.assertTrue((boolean)this.executed);
            FileModificationApproverTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            FileModificationApproverTest.assertSame((Object)EXECUTED, (Object)this.getCommandResult().getReturnValue());
        }

        public void assertNotExecuted() {
            FileModificationApproverTest.assertFalse((boolean)this.executed);
            FileModificationApproverTest.assertFalse((boolean)this.getCommandResult().getStatus().isOK());
        }

        public void assertUndone() {
            FileModificationApproverTest.assertTrue((boolean)this.undone);
            FileModificationApproverTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            FileModificationApproverTest.assertSame((Object)UNDONE, (Object)this.getCommandResult().getReturnValue());
        }

        public void assertNotUndone() {
            FileModificationApproverTest.assertFalse((boolean)this.undone);
            FileModificationApproverTest.assertFalse((boolean)this.getCommandResult().getStatus().isOK());
        }

        public void assertRedone() {
            FileModificationApproverTest.assertTrue((boolean)this.redone);
            FileModificationApproverTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            FileModificationApproverTest.assertSame((Object)REDONE, (Object)this.getCommandResult().getReturnValue());
        }

        public void assertNotRedone() {
            FileModificationApproverTest.assertFalse((boolean)this.redone);
            FileModificationApproverTest.assertFalse((boolean)this.getCommandResult().getStatus().isOK());
        }

        public void reset() {
            this.executed = false;
            this.undone = false;
            this.redone = false;
            this.setResult(null);
        }
    }
}

