/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.apps.airlines.exception;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.apps.airlines.exception.ReviewRejectedException;

@APIResponse(responseCode="400", description="The review was rejected", content={@Content(mediaType="application/json", schema=@Schema(implementation=RejectionResponse.class))})
public class ReviewRejectedExceptionMapper
implements ExceptionMapper<ReviewRejectedException> {
    public Response toResponse(ReviewRejectedException exception) {
        RejectionResponse response = new RejectionResponse();
        response.setReason(exception.getMessage());
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
    }

    public static class RejectionResponse {
        @Schema(description="The reason the review was rejected")
        private String reason;

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }
    }
}

