
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link Service}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableService.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableService implements Service {
  private final String id;
  private final Version version;
  private final Date createdAt;
  private final Date updatedAt;
  private final ServiceSpec spec;
  private final Endpoint endpoint;
  private final @Nullable UpdateStatus updateStatus;
  private final @Nullable JobStatus jobStatus;

  private ImmutableService(
      String id,
      Version version,
      Date createdAt,
      Date updatedAt,
      ServiceSpec spec,
      Endpoint endpoint,
      @Nullable UpdateStatus updateStatus,
      @Nullable JobStatus jobStatus) {
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.spec = spec;
    this.endpoint = endpoint;
    this.updateStatus = updateStatus;
    this.jobStatus = jobStatus;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("Version")
  @Override
  public Version version() {
    return version;
  }

  /**
   * @return The value of the {@code createdAt} attribute
   */
  @JsonProperty("CreatedAt")
  @Override
  public Date createdAt() {
    return createdAt;
  }

  /**
   * @return The value of the {@code updatedAt} attribute
   */
  @JsonProperty("UpdatedAt")
  @Override
  public Date updatedAt() {
    return updatedAt;
  }

  /**
   * @return The value of the {@code spec} attribute
   */
  @JsonProperty("Spec")
  @Override
  public ServiceSpec spec() {
    return spec;
  }

  /**
   * @return The value of the {@code endpoint} attribute
   */
  @JsonProperty("Endpoint")
  @Override
  public Endpoint endpoint() {
    return endpoint;
  }

  /**
   * @return The value of the {@code updateStatus} attribute
   */
  @JsonProperty("UpdateStatus")
  @Override
  public @Nullable UpdateStatus updateStatus() {
    return updateStatus;
  }

  /**
   * @return The value of the {@code jobStatus} attribute
   */
  @JsonProperty("JobStatus")
  @Override
  public @Nullable JobStatus jobStatus() {
    return jobStatus;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableService withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableService(
        newValue,
        this.version,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.endpoint,
        this.updateStatus,
        this.jobStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableService withVersion(Version value) {
    if (this.version == value) return this;
    Version newValue = Objects.requireNonNull(value, "version");
    return new ImmutableService(
        this.id,
        newValue,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.endpoint,
        this.updateStatus,
        this.jobStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableService withCreatedAt(Date value) {
    if (this.createdAt == value) return this;
    Date newValue = Objects.requireNonNull(value, "createdAt");
    return new ImmutableService(
        this.id,
        this.version,
        newValue,
        this.updatedAt,
        this.spec,
        this.endpoint,
        this.updateStatus,
        this.jobStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableService withUpdatedAt(Date value) {
    if (this.updatedAt == value) return this;
    Date newValue = Objects.requireNonNull(value, "updatedAt");
    return new ImmutableService(
        this.id,
        this.version,
        this.createdAt,
        newValue,
        this.spec,
        this.endpoint,
        this.updateStatus,
        this.jobStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#spec() spec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for spec
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableService withSpec(ServiceSpec value) {
    if (this.spec == value) return this;
    ServiceSpec newValue = Objects.requireNonNull(value, "spec");
    return new ImmutableService(
        this.id,
        this.version,
        this.createdAt,
        this.updatedAt,
        newValue,
        this.endpoint,
        this.updateStatus,
        this.jobStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#endpoint() endpoint} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for endpoint
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableService withEndpoint(Endpoint value) {
    if (this.endpoint == value) return this;
    Endpoint newValue = Objects.requireNonNull(value, "endpoint");
    return new ImmutableService(
        this.id,
        this.version,
        this.createdAt,
        this.updatedAt,
        this.spec,
        newValue,
        this.updateStatus,
        this.jobStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#updateStatus() updateStatus} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updateStatus (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableService withUpdateStatus(@Nullable UpdateStatus value) {
    if (this.updateStatus == value) return this;
    return new ImmutableService(
        this.id,
        this.version,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.endpoint,
        value,
        this.jobStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#jobStatus() jobStatus} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jobStatus (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableService withJobStatus(@Nullable JobStatus value) {
    if (this.jobStatus == value) return this;
    return new ImmutableService(
        this.id,
        this.version,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.endpoint,
        this.updateStatus,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableService} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableService
        && equalsByValue((ImmutableService) another);
  }

  private boolean equalsByValue(ImmutableService another) {
    return id.equals(another.id)
        && version.equals(another.version)
        && createdAt.equals(another.createdAt)
        && updatedAt.equals(another.updatedAt)
        && spec.equals(another.spec)
        && endpoint.equals(another.endpoint)
        && Objects.equals(updateStatus, another.updateStatus)
        && Objects.equals(jobStatus, another.jobStatus);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code version}, {@code createdAt}, {@code updatedAt}, {@code spec}, {@code endpoint}, {@code updateStatus}, {@code jobStatus}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + updatedAt.hashCode();
    h += (h << 5) + spec.hashCode();
    h += (h << 5) + endpoint.hashCode();
    h += (h << 5) + Objects.hashCode(updateStatus);
    h += (h << 5) + Objects.hashCode(jobStatus);
    return h;
  }

  /**
   * Prints the immutable value {@code Service} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Service{"
        + "id=" + id
        + ", version=" + version
        + ", createdAt=" + createdAt
        + ", updatedAt=" + updatedAt
        + ", spec=" + spec
        + ", endpoint=" + endpoint
        + ", updateStatus=" + updateStatus
        + ", jobStatus=" + jobStatus
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Service} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Service instance
   */
  public static ImmutableService copyOf(Service instance) {
    if (instance instanceof ImmutableService) {
      return (ImmutableService) instance;
    }
    return ImmutableService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableService ImmutableService}.
   * <pre>
   * ImmutableService.builder()
   *    .id(String) // required {@link Service#id() id}
   *    .version(org.mandas.docker.client.messages.swarm.Version) // required {@link Service#version() version}
   *    .createdAt(Date) // required {@link Service#createdAt() createdAt}
   *    .updatedAt(Date) // required {@link Service#updatedAt() updatedAt}
   *    .spec(org.mandas.docker.client.messages.swarm.ServiceSpec) // required {@link Service#spec() spec}
   *    .endpoint(org.mandas.docker.client.messages.swarm.Endpoint) // required {@link Service#endpoint() endpoint}
   *    .updateStatus(org.mandas.docker.client.messages.swarm.UpdateStatus | null) // nullable {@link Service#updateStatus() updateStatus}
   *    .jobStatus(org.mandas.docker.client.messages.swarm.JobStatus | null) // nullable {@link Service#jobStatus() jobStatus}
   *    .build();
   * </pre>
   * @return A new ImmutableService builder
   */
  public static ImmutableService.Builder builder() {
    return new ImmutableService.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableService ImmutableService}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VERSION = 0x2L;
    private static final long INIT_BIT_CREATED_AT = 0x4L;
    private static final long INIT_BIT_UPDATED_AT = 0x8L;
    private static final long INIT_BIT_SPEC = 0x10L;
    private static final long INIT_BIT_ENDPOINT = 0x20L;
    private long initBits = 0x3fL;

    private String id;
    private Version version;
    private Date createdAt;
    private Date updatedAt;
    private ServiceSpec spec;
    private Endpoint endpoint;
    private UpdateStatus updateStatus;
    private JobStatus jobStatus;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Service} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Service instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.id());
      this.version(instance.version());
      this.createdAt(instance.createdAt());
      this.updatedAt(instance.updatedAt());
      this.spec(instance.spec());
      this.endpoint(instance.endpoint());
      @Nullable UpdateStatus updateStatusValue = instance.updateStatus();
      if (updateStatusValue != null) {
        updateStatus(updateStatusValue);
      }
      @Nullable JobStatus jobStatusValue = instance.jobStatus();
      if (jobStatusValue != null) {
        jobStatus(jobStatusValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Service#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Service#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Version")
    public final Builder version(Version version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link Service#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CreatedAt")
    public final Builder createdAt(Date createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link Service#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("UpdatedAt")
    public final Builder updatedAt(Date updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
      initBits &= ~INIT_BIT_UPDATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link Service#spec() spec} attribute.
     * @param spec The value for spec 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Spec")
    public final Builder spec(ServiceSpec spec) {
      this.spec = Objects.requireNonNull(spec, "spec");
      initBits &= ~INIT_BIT_SPEC;
      return this;
    }

    /**
     * Initializes the value for the {@link Service#endpoint() endpoint} attribute.
     * @param endpoint The value for endpoint 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Endpoint")
    public final Builder endpoint(Endpoint endpoint) {
      this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
      initBits &= ~INIT_BIT_ENDPOINT;
      return this;
    }

    /**
     * Initializes the value for the {@link Service#updateStatus() updateStatus} attribute.
     * @param updateStatus The value for updateStatus (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("UpdateStatus")
    public final Builder updateStatus(@Nullable UpdateStatus updateStatus) {
      this.updateStatus = updateStatus;
      return this;
    }

    /**
     * Initializes the value for the {@link Service#jobStatus() jobStatus} attribute.
     * @param jobStatus The value for jobStatus (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("JobStatus")
    public final Builder jobStatus(@Nullable JobStatus jobStatus) {
      this.jobStatus = jobStatus;
      return this;
    }

    /**
     * Builds a new {@link ImmutableService ImmutableService}.
     * @return An immutable instance of Service
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableService build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableService(id, version, createdAt, updatedAt, spec, endpoint, updateStatus, jobStatus);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_UPDATED_AT) != 0) attributes.add("updatedAt");
      if ((initBits & INIT_BIT_SPEC) != 0) attributes.add("spec");
      if ((initBits & INIT_BIT_ENDPOINT) != 0) attributes.add("endpoint");
      return "Cannot build Service, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link Service.Criteria}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableService.Criteria.builder()}.
   */
  static final class Criteria implements Service.Criteria {
    private final @Nullable String serviceId;
    private final @Nullable String serviceName;
    private final Map<String, String> labels;

    private Criteria(
        @Nullable String serviceId,
        @Nullable String serviceName,
        Map<String, String> labels) {
      this.serviceId = serviceId;
      this.serviceName = serviceName;
      this.labels = labels;
    }

    /**
     * @return The value of the {@code serviceId} attribute
     */
    @JsonProperty(value = "serviceId")
    @Override
    public @Nullable String serviceId() {
      return serviceId;
    }

    /**
     * @return The value of the {@code serviceName} attribute
     */
    @JsonProperty(value = "serviceName")
    @Override
    public @Nullable String serviceName() {
      return serviceName;
    }

    /**
     * @return The value of the {@code labels} attribute
     */
    @JsonProperty(value = "labels", required = true)
    @Override
    public Map<String, String> labels() {
      return labels;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Service.Criteria#serviceId() serviceId} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for serviceId (can be {@code null})
     * @return A modified copy or the {@code this} object
     */
    public final ImmutableService.Criteria withServiceId(@Nullable String value) {
      if (Objects.equals(this.serviceId, value)) return this;
      return new ImmutableService.Criteria(value, this.serviceName, this.labels);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Service.Criteria#serviceName() serviceName} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for serviceName (can be {@code null})
     * @return A modified copy or the {@code this} object
     */
    public final ImmutableService.Criteria withServiceName(@Nullable String value) {
      if (Objects.equals(this.serviceName, value)) return this;
      return new ImmutableService.Criteria(this.serviceId, value, this.labels);
    }

    /**
     * Copy the current immutable object by replacing the {@link Service.Criteria#labels() labels} map with the specified map.
     * Nulls are not permitted as keys or values.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param entries The entries to replace the labels map
     * @return A modified copy or {@code this} if not changed
     */
    public final ImmutableService.Criteria withLabels(Map<String, ? extends String> entries) {
      if (this.labels == entries) return this;
      Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
      return new ImmutableService.Criteria(this.serviceId, this.serviceName, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Criteria} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableService.Criteria
          && equalsByValue((ImmutableService.Criteria) another);
    }

    private boolean equalsByValue(ImmutableService.Criteria another) {
      return Objects.equals(serviceId, another.serviceId)
          && Objects.equals(serviceName, another.serviceName)
          && labels.equals(another.labels);
    }

    /**
     * Computes a hash code from attributes: {@code serviceId}, {@code serviceName}, {@code labels}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Objects.hashCode(serviceId);
      h += (h << 5) + Objects.hashCode(serviceName);
      h += (h << 5) + labels.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Criteria} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Criteria{"
          + "serviceId=" + serviceId
          + ", serviceName=" + serviceName
          + ", labels=" + labels
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link Service.Criteria} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Criteria instance
     */
    public static ImmutableService.Criteria copyOf(Service.Criteria instance) {
      if (instance instanceof ImmutableService.Criteria) {
        return (ImmutableService.Criteria) instance;
      }
      return ImmutableService.Criteria.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableService.Criteria Criteria}.
     * <pre>
     * ImmutableService.Criteria.builder()
     *    .serviceId(String | null) // nullable {@link Service.Criteria#serviceId() serviceId}
     *    .serviceName(String | null) // nullable {@link Service.Criteria#serviceName() serviceName}
     *    .addLabel|putAllLabels(String =&gt; String) // {@link Service.Criteria#labels() labels} mappings
     *    .build();
     * </pre>
     * @return A new Criteria builder
     */
    public static ImmutableService.Criteria.Builder builder() {
      return new ImmutableService.Criteria.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableService.Criteria Criteria}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder implements Service.Criteria.Builder {
      private String serviceId;
      private String serviceName;
      private Map<String, String> labels = new LinkedHashMap<String, String>();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Criteria} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Service.Criteria instance) {
        Objects.requireNonNull(instance, "instance");
        @Nullable String serviceIdValue = instance.serviceId();
        if (serviceIdValue != null) {
          serviceId(serviceIdValue);
        }
        @Nullable String serviceNameValue = instance.serviceName();
        if (serviceNameValue != null) {
          serviceName(serviceNameValue);
        }
        putAllLabels(instance.labels());
        return this;
      }

      /**
       * Initializes the value for the {@link Service.Criteria#serviceId() serviceId} attribute.
       * @param serviceId The value for serviceId (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty(value = "serviceId")
      public final Builder serviceId(@Nullable String serviceId) {
        this.serviceId = serviceId;
        return this;
      }

      /**
       * Initializes the value for the {@link Service.Criteria#serviceName() serviceName} attribute.
       * @param serviceName The value for serviceName (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty(value = "serviceName")
      public final Builder serviceName(@Nullable String serviceName) {
        this.serviceName = serviceName;
        return this;
      }

      /**
       * Put one entry to the {@link Service.Criteria#labels() labels} map.
       * @param key The key in the labels map
       * @param value The associated value in the labels map
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addLabel(String key, String value) {
        this.labels.put(
            Objects.requireNonNull(key, "labels key"),
            Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
        return this;
      }

      /**
       * Put one entry to the {@link Service.Criteria#labels() labels} map. Nulls are not permitted
       * @param entry The key and value entry
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.labels.put(
            Objects.requireNonNull(k, "labels key"),
            Objects.requireNonNull(v, v == null ? "labels value for key: " + k : null));
        return this;
      }

      /**
       * Sets or replaces all mappings from the specified map as entries for the {@link Service.Criteria#labels() labels} map. Nulls are not permitted
       * @param entries The entries that will be added to the labels map
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty(value = "labels", required = true)
      public final Builder labels(Map<String, ? extends String> entries) {
        this.labels.clear();
        return putAllLabels(entries);
      }

      /**
       * Put all mappings from the specified map as entries to {@link Service.Criteria#labels() labels} map. Nulls are not permitted
       * @param entries The entries that will be added to the labels map
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder putAllLabels(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
          String k = e.getKey();
          String v = e.getValue();
          this.labels.put(
              Objects.requireNonNull(k, "labels key"),
              Objects.requireNonNull(v, v == null ? "labels value for key: " + k : null));
        }
        return this;
      }

      /**
       * Builds a new {@link ImmutableService.Criteria Criteria}.
       * @return An immutable instance of Criteria
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableService.Criteria build() {
        return new ImmutableService.Criteria(serviceId, serviceName, createUnmodifiableMap(false, false, labels));
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
