/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ImmutablePlacement;
import org.mandas.docker.client.messages.swarm.Preference;

@JsonDeserialize(builder=ImmutablePlacement.Builder.class)
@Value.Immutable
public interface Placement {
    @JsonProperty(value="Constraints")
    @Nullable
    public List<String> constraints();

    @JsonProperty(value="Preferences")
    @Nullable
    public List<Preference> preferences();

    @JsonProperty(value="MaxReplicas")
    @Nullable
    public Integer maxReplicas();

    public static Placement create(List<String> constraints) {
        return Placement.create(constraints, null, null);
    }

    public static Placement create(List<String> constraints, List<Preference> preferences) {
        return Placement.create(constraints, preferences, null);
    }

    public static Placement create(List<String> constraints, List<Preference> preferences, Integer maxReplicas) {
        return ImmutablePlacement.builder().constraints(constraints).preferences(preferences).maxReplicas(maxReplicas).build();
    }
}

