/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.gemini.web.core.WebBundleManifestTransformer;
import org.eclipse.gemini.web.core.WebContainer;
import org.eclipse.gemini.web.core.spi.ServletContainer;
import org.eclipse.gemini.web.internal.EventManager;
import org.eclipse.gemini.web.internal.StandardWebContainer;
import org.eclipse.gemini.web.internal.SystemBundleExportsResolver;
import org.eclipse.gemini.web.internal.url.ChainingWebBundleManifestTransformer;
import org.eclipse.gemini.web.internal.url.DefaultsWebBundleManifestTransformer;
import org.eclipse.gemini.web.internal.url.SpecificationWebBundleManifestTransformer;
import org.eclipse.gemini.web.internal.url.SystemBundleExportsImportingWebBundleManifestTransformer;
import org.eclipse.gemini.web.internal.url.WebBundleUrlStreamHandlerService;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WebContainerActivator
implements BundleActivator {
    private final ServiceRegistrationTracker regTracker = new ServiceRegistrationTracker();
    private volatile EventManager eventManager;
    private ServiceTracker<ServletContainer, WebContainer> serviceTracker;

    public void start(BundleContext context) throws Exception {
        WebBundleManifestTransformer transformer = this.registerWebBundleManifestTransformer(context);
        this.registerUrlStreamHandler(context, transformer);
        this.eventManager = new EventManager(context);
        this.eventManager.start();
        this.serviceTracker = new ServiceTracker(context, ServletContainer.class, (ServiceTrackerCustomizer)new ServletContainerTracker(context, this.eventManager));
        this.serviceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceTracker.close();
        this.regTracker.unregisterAll();
        this.eventManager.stop();
    }

    private WebBundleManifestTransformer registerWebBundleManifestTransformer(BundleContext context) {
        SpecificationWebBundleManifestTransformer specTransformer = new SpecificationWebBundleManifestTransformer();
        DefaultsWebBundleManifestTransformer defaultsTransformer = new DefaultsWebBundleManifestTransformer();
        Map<String, VersionRange> systemBundleExports = new SystemBundleExportsResolver(context).getSystemBundleExports();
        SystemBundleExportsImportingWebBundleManifestTransformer systemBundleExportImportingWebBundleManifestTransformer = new SystemBundleExportsImportingWebBundleManifestTransformer(systemBundleExports);
        ChainingWebBundleManifestTransformer chainingTransformer = new ChainingWebBundleManifestTransformer(specTransformer, defaultsTransformer, systemBundleExportImportingWebBundleManifestTransformer);
        ServiceRegistration reg = context.registerService(WebBundleManifestTransformer.class, (Object)chainingTransformer, null);
        this.regTracker.track(reg);
        return chainingTransformer;
    }

    private void registerUrlStreamHandler(BundleContext context, WebBundleManifestTransformer transformer) {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("url.handler.protocol", new String[]{"webbundle"});
        ServiceRegistration reg = context.registerService(URLStreamHandlerService.class, (Object)new WebBundleUrlStreamHandlerService(transformer), props);
        this.regTracker.track(reg);
    }

    private static final class ServletContainerTracker
    implements ServiceTrackerCustomizer<ServletContainer, WebContainer> {
        private final ServiceRegistrationTracker regTracker = new ServiceRegistrationTracker();
        private final BundleContext context;
        private final EventManager eventManager;

        public ServletContainerTracker(BundleContext context, EventManager eventManager) {
            this.context = context;
            this.eventManager = eventManager;
        }

        public WebContainer addingService(ServiceReference<ServletContainer> reference) {
            ServletContainer container = (ServletContainer)this.context.getService(reference);
            StandardWebContainer webContainer = new StandardWebContainer(container, this.eventManager);
            ServiceRegistration reg = this.context.registerService(WebContainer.class, (Object)webContainer, null);
            this.regTracker.track(reg);
            return webContainer;
        }

        public void modifiedService(ServiceReference<ServletContainer> reference, WebContainer service) {
        }

        public void removedService(ServiceReference<ServletContainer> reference, WebContainer service) {
            this.regTracker.unregisterAll();
            service.halt();
        }
    }
}

