/**
 * Copyright (c) 2024 mka and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.elk.core.meta.validation;

import com.google.inject.Inject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.validation.UniqueClassNameValidator;

/**
 * Overwrites the UniqueClassNameValidator to only check for melk files in src folders. This probably
 * prevents some special use cases where ELK is used as a library and a new melk file is created.
 */
@SuppressWarnings("all")
public class MelkUniqueClassNameValidator extends UniqueClassNameValidator {
  @Inject
  private ResourceDescriptionsProvider resourceDescriptionsProvider;

  @Override
  public boolean doCheckUniqueName(final QualifiedName name, final JvmDeclaredType type) {
    final IResourceDescriptions index = this.resourceDescriptionsProvider.getResourceDescriptions(type.eResource());
    final Iterable<IEObjectDescription> others = index.getExportedObjects(TypesPackage.Literals.JVM_DECLARED_TYPE, name, false);
    final Function1<IEObjectDescription, Boolean> _function = (IEObjectDescription it) -> {
      final Function1<String, Boolean> _function_1 = (String it_1) -> {
        return Boolean.valueOf(it_1.contains("src"));
      };
      return Boolean.valueOf(IterableExtensions.<String>exists(((Iterable<String>)Conversions.doWrapArray(it.getEObjectURI().segments())), _function_1));
    };
    return this.checkUniqueInIndex(type, IterableExtensions.<IEObjectDescription>filter(others, _function));
  }
}
