/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

public class ComparisonResourceManager
implements IDisposable {
    private final Map<Image, Image> _normalToDisabled = new HashMap<Image, Image>();
    private final Map<ImageOverlay, Image> _normalToOverlay = new HashMap<ImageOverlay, Image>();

    public Image adaptImage(Image image_p, DifferenceKind kind_p) {
        Image result = image_p;
        if (kind_p != null && image_p != null) {
            EMFDiffMergeUIPlugin.ImageID overlay = EMFDiffMergeUIPlugin.getDefault().getDifferenceOverlay(kind_p);
            result = this.getOverlayVersion(image_p, overlay);
        }
        return result;
    }

    public void dispose() {
        for (Image disabled : this._normalToDisabled.values()) {
            disabled.dispose();
        }
        this._normalToDisabled.clear();
        for (Image overlay : this._normalToOverlay.values()) {
            overlay.dispose();
        }
        this._normalToOverlay.clear();
    }

    public Image getDisabledVersion(Image image_p) {
        Image result = this._normalToDisabled.get(image_p);
        if (result == null) {
            result = new Image(image_p.getDevice(), image_p, 1);
            this._normalToDisabled.put(image_p, result);
        }
        return result;
    }

    public Image getOverlayVersion(Image image_p, EMFDiffMergeUIPlugin.ImageID overlay_p) {
        Image result;
        if (overlay_p == null) {
            result = image_p;
        } else {
            ImageOverlay io = new ImageOverlay(image_p, overlay_p);
            result = this._normalToOverlay.get(io);
            if (result == null) {
                ImageDescriptor overlayDescriptor = EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(overlay_p);
                DecorationOverlayIcon icon = new DecorationOverlayIcon(image_p, overlayDescriptor, 3);
                result = icon.createImage(image_p.getDevice());
                this._normalToOverlay.put(io, result);
            }
        }
        return result;
    }

    public static class ImageOverlay {
        private Image _image;
        private EMFDiffMergeUIPlugin.ImageID _overlay;

        public ImageOverlay(Image image_p, EMFDiffMergeUIPlugin.ImageID overlay_p) {
            this._image = image_p;
            this._overlay = overlay_p;
        }

        public int hashCode() {
            return this._image.hashCode() + this._overlay.hashCode();
        }

        public boolean equals(Object object_p) {
            boolean result = false;
            if (object_p instanceof ImageOverlay) {
                ImageOverlay peer = (ImageOverlay)object_p;
                result = this._image.equals((Object)peer._image) && this._overlay.equals((Object)peer._overlay);
            }
            return result;
        }
    }
}

