/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.update;

import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdateSource;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceQuery;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.dialogs.MultilineInputDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLStringHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.UpdateHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.WorkbenchUtility;
import org.eclipse.swt.widgets.Display;

public class UpdateTreeElement {
    protected QueryUpdateStatement updateStmt;
    protected UpdateSource updateSource;
    protected ValueExpressionColumn column;
    protected SQLQueryObject valueSource;
    protected SQLDomainModel domainModel;
    protected boolean hasChildren;

    public UpdateTreeElement(QueryUpdateStatement update, UpdateSource updateSrc, ValueExpressionColumn col, SQLQueryObject valueSource, SQLDomainModel domainModel, boolean hasChildren) {
        this.updateStmt = update;
        this.updateSource = updateSrc;
        this.valueSource = valueSource;
        this.column = col;
        this.domainModel = domainModel;
        this.hasChildren = hasChildren;
    }

    public QueryUpdateStatement getUpdateStatement() {
        return this.updateStmt;
    }

    public UpdateSource getUpdateSource() {
        return this.updateSource;
    }

    public ValueExpressionColumn getRDBColumn() {
        return this.column;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public String getColumnText(int columnIndex) {
        String columnText = "";
        if (columnIndex == 0) {
            columnText = this.column != null ? this.column.getSQL() : Messages._UI_COLUMN_UPDATE_GROUP;
        } else if (columnIndex == 1 && this.updateSource != null) {
            VendorHelper vHelper = new VendorHelper(this.domainModel.getDatabase());
            if (this.column == null && this.updateSource instanceof UpdateSourceQuery || this.column != null && vHelper.isSybase()) {
                columnText = SQLStringHelper.trimBlanks(((UpdateSourceQuery)this.updateSource).getQueryExpr().getSQL());
            } else if (this.valueSource != null) {
                columnText = this.valueSource.getSQL();
            }
        }
        return columnText;
    }

    public void modify(Object key, Object propValue) {
        if (key == SQLBuilderConstants.P_EXPRESSION) {
            IFile query;
            QueryValueExpression newSource = null;
            if (propValue instanceof String) {
                if (propValue.equals(SQLBuilderConstants.P_ADD_SELECT) || propValue.equals(SQLBuilderConstants.P_ADD_FULLSELECT)) {
                    if (propValue.equals(SQLBuilderConstants.P_ADD_SELECT)) {
                        QuerySelect select = StatementHelper.createQuerySelect();
                        UpdateAssignmentExpression assignExpr = this.updateSource.getUpdateAssignmentExpr();
                        UpdateHelper.createUpdateSourceQuery(assignExpr, (QueryExpressionBody)select);
                    } else if (propValue.equals(SQLBuilderConstants.P_ADD_FULLSELECT)) {
                        QueryCombined qCombined = StatementHelper.createQueryCombined();
                        QuerySelect leftQSelect = StatementHelper.createQuerySelect();
                        QuerySelect rightQSelect = StatementHelper.createQuerySelect();
                        qCombined.setLeftQuery((QueryExpressionBody)leftQSelect);
                        qCombined.setRightQuery((QueryExpressionBody)rightQSelect);
                        UpdateAssignmentExpression assignExpr = this.updateSource.getUpdateAssignmentExpr();
                        UpdateHelper.createUpdateSourceQuery(assignExpr, (QueryExpressionBody)qCombined);
                    }
                } else if (propValue.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || propValue.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION) || propValue.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                    newSource = this.showExpressionBuilder(this.valueSource, false, (String)propValue);
                } else if (propValue.equals(SQLBuilderConstants.P_EDIT_INPUT_VALUE)) {
                    newSource = this.showInputEditor(this.valueSource.getSQL());
                }
            } else if (propValue instanceof QueryValueExpression) {
                newSource = (QueryValueExpression)propValue;
            } else if (propValue instanceof IFile && (query = (IFile)propValue) != null) {
                QueryStatement stmt;
                String fileContent = WorkbenchUtility.readFileContentsToString(query, true).trim();
                try {
                    stmt = this.domainModel.parse(fileContent, true);
                }
                catch (SQLParserException e) {
                    SQLDomainModel.showParseErrors((Exception)((Object)e));
                    return;
                }
                catch (SQLParserInternalException e) {
                    SQLDomainModel.showParseErrors((Exception)((Object)e));
                    return;
                }
                QueryExpressionBody queryExprBody = SelectHelper.getQueryExpressionBody((QuerySelectStatement)stmt);
                UpdateAssignmentExpression assignExpr = this.updateSource.getUpdateAssignmentExpr();
                UpdateHelper.createUpdateSourceQuery(assignExpr, queryExprBody);
            }
            if (newSource != null) {
                this.valueSource = newSource;
                if (newSource instanceof QueryValueExpression) {
                    if (this.updateSource instanceof UpdateSourceExprList) {
                        UpdateHelper.setValueForColumn((UpdateSourceExprList)this.updateSource, this.column, newSource);
                    } else {
                        UpdateAssignmentExpression assignExpr = this.updateSource.getUpdateAssignmentExpr();
                        UpdateHelper.createUpdateSourceExpressionList(assignExpr, this.column, newSource);
                    }
                }
            }
            this.getUpdateStatement().setTargetTable(this.getUpdateStatement().getTargetTable());
        }
    }

    public QueryValueExpression showExpressionBuilder(Object obj, boolean isColumn, String action) {
        QueryValueExpression expr = null;
        ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(this.domainModel, (SQLQueryObject)this.domainModel.getSQLStatement());
        if (obj instanceof QueryValueExpression && action.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
            if (obj != null) {
                wizard.setInputExpression((QueryValueExpression)obj);
            } else {
                wizard.setInputExpression(null);
            }
        }
        wizard.setIsColumn(isColumn);
        ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            expr = wizard.getSQLExpression();
        }
        return expr;
    }

    protected QueryValueExpression showInputEditor(String initialText) {
        MultilineInputDialog inputDialog = new MultilineInputDialog(Display.getDefault().getActiveShell(), Messages._UI_SPECIFY_VALUE_TITLE, this.column.getName());
        inputDialog.setText(initialText);
        inputDialog.open();
        String text = inputDialog.getText();
        QueryValueExpression expression = ExpressionHelper.createExpression(text);
        return expression;
    }
}

