/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.execute;

import java.util.Vector;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.InputValueCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterElement;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterMarkerPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ParameterTableViewer
extends NavigableTableViewer {
    public static final String P_MARKER_NAME = "org.eclipse.datatools.sqltools.sqlbuilder.views.execute.name";
    public static final String P_MARKER_TYPE = "org.eclipse.datatools.sqltools.sqlbuilder.views.execute.type";
    public static final String P_MARKER_VALUE = "org.eclipse.datatools.sqltools.sqlbuilder.views.execute.value";
    private Table table;
    private TableColumn c1;
    private TableColumn c2;
    private TableColumn c3;
    private ParameterMarkerPage parameterMarkerPage;
    InputValueCellEditor inputCellEditor;

    public ParameterTableViewer(ParameterMarkerPage pmp, int style, Composite parent, Vector parmMarkers) {
        super(new Table(parent, style));
        this.parameterMarkerPage = pmp;
        this.table = this.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.c1 = new TableColumn(this.table, 0);
        this.c1.setText(Messages._UI_COLUMN_MARKER_NAME);
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_TYPE);
        this.c3 = new TableColumn(this.table, 0);
        this.c3.setText(Messages._UI_COLUMN_PARAMETER_VALUE);
        String[] items = new String[]{Messages._UI_SPECIFY_VALUE};
        this.inputCellEditor = new InputValueCellEditor((Composite)this.table, this, items);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(130, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(130, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(130, true));
        this.table.setLayout((Layout)layout);
        String[] properties = new String[]{P_MARKER_NAME, P_MARKER_TYPE, P_MARKER_VALUE};
        this.setColumnProperties(properties);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = this.inputCellEditor;
        CellEditor[] editors = cellEditorArray;
        this.setCellEditors(editors);
        this.setCellModifier(new ParameterTableCellModifier(this));
        this.setContentProvider((IContentProvider)new ParameterContentProvider(parmMarkers));
        this.setLabelProvider((IBaseLabelProvider)new ParameterLabelProvider());
    }

    public ParameterMarkerPage getParameterMarkerPage() {
        return this.parameterMarkerPage;
    }

    class ParameterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ParameterLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof ParameterElement) {
                return ((ParameterElement)object).getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }

    public class ParameterTableCellModifier
    implements ICellModifier {
        ParameterTableViewer viewer;
        Object currentElement;
        Object currentProperty;
        Object currentValue;
        ParameterElement parameterElement;

        public ParameterTableCellModifier(ParameterTableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return property.equals(ParameterTableViewer.P_MARKER_VALUE);
        }

        public Object getValue(Object element, String property) {
            return element;
        }

        public void modify(Object element, String property, Object value) {
            this.currentElement = element;
            this.currentProperty = property;
            this.currentValue = value;
            if (property.equals(ParameterTableViewer.P_MARKER_VALUE)) {
                Object data = ((TableItem)this.currentElement).getData();
                if (this.currentValue == null) {
                    return;
                }
                if (data instanceof ParameterElement) {
                    this.parameterElement = (ParameterElement)data;
                    if (value instanceof String) {
                        this.parameterElement.setValue((String)value);
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ParameterTableCellModifier.this.viewer.refresh();
                            }
                        });
                        ParameterTableViewer.this.getParameterMarkerPage().updateFinishButton();
                    }
                }
            }
        }
    }

    public class ParameterValueCellEditor
    extends TextCellEditor
    implements FocusListener {
        public ParameterValueCellEditor(Composite parent) {
            super(parent);
            this.setValidator(null);
            this.text.addFocusListener((FocusListener)this);
        }

        public void focusLost(FocusEvent e) {
            this.fireApplyEditorValue();
        }

        public void focusGained(FocusEvent e) {
        }

        protected void doSetValue(Object value) {
            if (value instanceof ParameterElement) {
                ParameterElement pe = (ParameterElement)value;
                String result = pe.getColumnText(2);
                super.doSetValue((Object)result);
            }
        }
    }
}

