/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.dialogs.SourceTargetDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

public class CreateJoinAction
extends Action {
    QuerySelect querySelect;
    TableExpression sourceTable;
    SQLDomainModel domainModel;
    QuerySelectStatement querySelectStmt;

    public CreateJoinAction(SQLDomainModel domainModel) {
        super(Messages._UI_ACTION_CREATE_JOIN);
        this.domainModel = domainModel;
    }

    public void setStatement(SQLQueryObject statement) {
        if (statement instanceof QuerySelectStatement) {
            QueryExpressionBody queryExpr;
            this.querySelectStmt = (QuerySelectStatement)statement;
            QueryExpressionRoot root = this.querySelectStmt.getQueryExpr();
            if (root != null && (queryExpr = root.getQuery()) instanceof QuerySelect) {
                this.querySelect = (QuerySelect)queryExpr;
            }
        } else if (statement instanceof QuerySelect) {
            QueryStatement qStmt = StatementHelper.getQueryStatementForTableReference((TableReference)((QuerySelect)statement));
            if (qStmt instanceof QuerySelectStatement) {
                this.querySelectStmt = (QuerySelectStatement)qStmt;
                this.querySelect = (QuerySelect)statement;
            }
        } else {
            this.querySelect = null;
        }
    }

    public void setSourceTable(TableExpression table) {
        this.sourceTable = table;
    }

    public void run() {
        SourceTargetDialog dialog = new SourceTargetDialog(Display.getCurrent().getActiveShell(), this.sourceTable, this.querySelect, this.domainModel);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int value = dialog.open();
        if (value == 1) {
            return;
        }
        TableExpression srcTable = dialog.getSourceTable();
        TableExpression targetTable = dialog.getTargetTable();
        ValueExpressionColumn sourceColumn = dialog.getSourceColumn();
        ValueExpressionColumn targetColumn = dialog.getTargetColumn();
        ValueExpressionColumn sourceColumnCopy = ExpressionHelper.createValueExpressionColumn(sourceColumn);
        ValueExpressionColumn targetColumnCopy = ExpressionHelper.createValueExpressionColumn(targetColumn);
        int joinKind = dialog.getJoinType();
        if (srcTable != null && targetTable != null && sourceColumn != null && targetColumn != null && this.querySelect != null) {
            EList fromClause = this.querySelect.getFromClause();
            JoinHelper.addJoin((List)fromClause, (TableExpression)srcTable, (TableExpression)targetTable, (ValueExpressionColumn)sourceColumnCopy, (ValueExpressionColumn)targetColumnCopy, (int)joinKind);
            SelectHelper.refresh(this.querySelectStmt);
        }
    }
}

