/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.columns;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.columns.ASATableEditorColumnRowData;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.columns.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils.TableModelUtil;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableDataCellModifier;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;

public class ASATableEditorColumnsViewerCellModifier
extends TableDataCellModifier {
    public ASATableEditorColumnsViewerCellModifier(AccessibleTableViewer viewer, BaseTable table) {
        super(viewer);
    }

    public void setViewer(AccessibleTableViewer viewer) {
        this._viewer = viewer;
    }

    public void modify(Object element, String property, Object value) {
        boolean needContinue;
        IRowData row = this._viewer.getRow();
        boolean orginalPKState = false;
        if (row != null && row.getValue(1) != null) {
            orginalPKState = Boolean.parseBoolean((String)row.getValue(1));
        }
        super.modify(element, property, value);
        row = this._viewer.getRow();
        int column = this.getColumnIndex(property);
        boolean nullable = false;
        if (row.getValue(4) != null) {
            nullable = Boolean.valueOf((String)row.getValue(4));
        }
        boolean isPK = false;
        if (row.getValue(1) != null) {
            isPK = Boolean.valueOf((String)row.getValue(1));
        }
        if (column == 1) {
            if (nullable && isPK) {
                row.updateValue(4, (Object)"false");
            }
            if (!isPK && orginalPKState) {
                needContinue = this.removeReferencingUniqueConstraints((ASATableEditorColumnRowData)row, true);
                if (!needContinue) {
                    row.updateValue(1, (Object)"true");
                } else {
                    ((ASATableEditorColumnRowData)row).markDirty(true);
                    this._viewer.refresh();
                }
            } else if (isPK && !orginalPKState) {
                ((ASATableEditorColumnRowData)row).markDirty(true);
                this._viewer.refresh();
            }
        }
        if (column == 4 && nullable && (needContinue = this.removeReferencingUniqueConstraints((ASATableEditorColumnRowData)row, false))) {
            row.updateValue(1, (Object)"false");
        }
        this._viewer.refresh();
    }

    private boolean removeReferencingUniqueConstraints(ASATableEditorColumnRowData asaRow, boolean onlyRemovePK) {
        if (asaRow.getColumn() != null) {
            BaseTable table = (BaseTable)asaRow.getColumn().eContainer();
            ArrayList matches = TableModelUtil.getMatchedColumnUniqueConstraint(table, (Column)asaRow.getColumn());
            if (onlyRemovePK) {
                Iterator iter = matches.iterator();
                matches = new ArrayList();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof PrimaryKey)) continue;
                    matches.add(obj);
                    break;
                }
            }
            if (matches.size() > 0) {
                MessageDialog d = new MessageDialog(this._viewer.getControl().getShell(), Messages.ASATableEditorColumnsViewerCellModifier_remove_constraints, null, String.valueOf(Messages.ASATableEditorColumnsViewerCellModifier_constraints_remove_also) + TableModelUtil.constructConstraintNamesList(matches) + Messages.ASATableEditorColumnsViewerCellModifier_continue, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                d.open();
                int result = d.getReturnCode();
                switch (result) {
                    case 0: {
                        Iterator iter = matches.iterator();
                        ArrayList uniquesTobeRemoved = new ArrayList();
                        while (iter.hasNext()) {
                            uniquesTobeRemoved.add(iter.next());
                        }
                        table.getConstraints().removeAll(uniquesTobeRemoved);
                        return true;
                    }
                    case 1: {
                        asaRow.updateValue(4, "false");
                        this._viewer.refresh();
                        return false;
                    }
                }
            }
            boolean nullable = false;
            if (asaRow.getValue(4) != null) {
                nullable = Boolean.valueOf((String)asaRow.getValue(4));
            }
            if (nullable) {
                TableModelUtil.removeColumnFromRefConstraints(table, (Column)asaRow.getColumn());
            }
            boolean isPK = false;
            if (asaRow.getValue(1) != null) {
                isPK = Boolean.valueOf((String)asaRow.getValue(1));
            }
            if (table.getPrimaryKey() != null && !isPK) {
                table.getPrimaryKey().getMembers().remove((Object)asaRow.getColumn());
            }
        }
        return true;
    }

    public boolean canChange(Object element, int index) {
        if (index == 6) {
            return false;
        }
        return index != 0;
    }
}

