/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation;

import java.util.Map;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseTrigger;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.ITriggerValidatorConstants;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.modelvalidity.DefaultSQLModelValidator;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class SybaseASATriggerValidator
extends DefaultSQLModelValidator
implements ITriggerValidatorConstants {
    protected boolean validateAttribute(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid = true;
        SybaseASABaseTrigger trigger = (SybaseASABaseTrigger)eObject;
        Table table = trigger.getSubjectTable();
        Trigger originalTrigger = (Trigger)sharedParams.get("original_model");
        if (originalTrigger != null) {
            table = originalTrigger.getSubjectTable();
        }
        DatabaseIdentifier databaseIdentifier = (DatabaseIdentifier)sharedParams.get("didentifier");
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfiguration((DatabaseIdentifier)databaseIdentifier, null);
        IIdentifierValidator identifierValidator = conf.getSQLService().getIdentifierValidator();
        if (featureId == 1) {
            if (trigger.getName() == null || trigger.getName().trim().equals("")) {
                isValid = false;
                BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(1), 1000, Messages.SybaseTriggerValidator_No_name_present, new Object[]{trigger});
                diagnostics.add((Diagnostic)d);
            } else if (databaseIdentifier != null) {
                String quotedName = SQLUtil.quoteWhenNecessary(trigger.getName(), databaseIdentifier);
                ValidatorMessage msg = identifierValidator.isValid(quotedName, 7, databaseIdentifier);
                if (msg != null && msg.getType() != 0) {
                    isValid = false;
                    BasicDiagnostic d = new BasicDiagnostic(this.getDiagnosticCode(msg.getType()), Integer.toString(1), 1001, String.valueOf(NLS.bind((String)Messages.SybaseTriggerValidator_for_trigger, (Object)trigger.getName())) + msg.getMessage(), new Object[]{trigger});
                    diagnostics.add((Diagnostic)d);
                } else if (table != null) {
                    EList triggers = table.getTriggers();
                    for (Trigger otherTrigger : triggers) {
                        if (otherTrigger == trigger || otherTrigger == originalTrigger || !trigger.getName().equals(otherTrigger.getName())) continue;
                        isValid = false;
                        BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(1), 0, NLS.bind((String)Messages.Trigger_Duplicate_Name_Error, (Object)trigger.getName()), new Object[]{trigger});
                        diagnostics.add((Diagnostic)d);
                        break;
                    }
                }
            }
        } else if (featureId == 17 || featureId == 16 || featureId == 18 || featureId == 26) {
            isValid = this.hasEvents(diagnostics, (Trigger)trigger, featureId);
            boolean bl = isValid = isValid && this.isUniqueType(diagnostics, (Trigger)trigger, featureId, sharedParams);
            if (featureId == 26 && trigger.isUpdateColumnType() && (trigger.getTriggerColumn() == null || trigger.getTriggerColumn().isEmpty())) {
                isValid = false;
                BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(26), 10005, NLS.bind((String)Messages.Validator_No_trigger_column, (Object)trigger.getName()), new Object[]{trigger});
                diagnostics.add((Diagnostic)d);
            }
        } else if (featureId == 23) {
            isValid = this.isUniqueType(diagnostics, (Trigger)trigger, featureId, sharedParams);
        } else if (featureId == 15) {
            isValid = this.isUniqueType(diagnostics, (Trigger)trigger, featureId, sharedParams);
        } else if (featureId == 19 || featureId == 21 || featureId == 20 || featureId == 22 || featureId == 25) {
            ValidatorMessage msg;
            String refName = null;
            refName = featureId == 19 || featureId == 21 ? trigger.getOldName() : (featureId == 20 || featureId == 22 ? trigger.getNewName() : trigger.getRemoteName());
            if (refName != null && !refName.trim().equals("") && (msg = identifierValidator.isValid(refName, 7, databaseIdentifier)) != null && msg.getType() != 0) {
                isValid = false;
                BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(featureId), 1001, String.valueOf(msg.getMessage()) + ": " + refName, new Object[]{trigger});
                diagnostics.add((Diagnostic)d);
            }
        }
        return isValid;
    }

    private boolean hasEvents(DiagnosticChain diagnostics, Trigger trigger, int featureId) {
        boolean isValid = true;
        if (!(trigger.isDeleteType() || trigger.isInsertType() || trigger.isUpdateType() || ((SybaseASABaseTrigger)trigger).isUpdateColumnType())) {
            Diagnostic d2;
            isValid = false;
            for (Diagnostic d2 : ((BasicDiagnostic)diagnostics).getChildren()) {
                if (d2.getCode() != 10001 || !d2.getData().contains(trigger)) continue;
                return isValid;
            }
            d2 = new BasicDiagnostic(4, Integer.toString(featureId), 10001, NLS.bind((String)Messages.Validator_No_trigger_events, (Object)trigger.getName()), new Object[]{trigger});
            diagnostics.add(d2);
        }
        return isValid;
    }

    private boolean isUniqueType(DiagnosticChain diagnostics, Trigger trigger, int featureId, Map sharedParams) {
        boolean isValid = true;
        Table table = trigger.getSubjectTable();
        Trigger originalTrigger = (Trigger)sharedParams.get("original_model");
        if (originalTrigger != null) {
            table = originalTrigger.getSubjectTable();
        }
        if (table != null) {
            int triggerType = this.getTriggerEventType(trigger);
            int triggerTime = ((SybaseASABaseTrigger)trigger).getSybaseASABaseActionTime().getValue();
            int order = ((SybaseASABaseTrigger)trigger).getOrder();
            EList triggers = table.getTriggers();
            for (Trigger otherTrigger : triggers) {
                Diagnostic d2;
                if (otherTrigger == trigger || otherTrigger == originalTrigger) continue;
                int eType = this.getTriggerEventType(otherTrigger);
                int eTime = ((SybaseASABaseTrigger)otherTrigger).getSybaseASABaseActionTime().getValue();
                int eOrder = ((SybaseASABaseTrigger)otherTrigger).getOrder();
                if (eType != triggerType || triggerTime != eTime || order != eOrder) continue;
                isValid = false;
                for (Diagnostic d2 : ((BasicDiagnostic)diagnostics).getChildren()) {
                    if (d2.getCode() != 10004 || !d2.getData().contains(trigger) || !d2.getData().contains(otherTrigger)) continue;
                    return isValid;
                }
                d2 = new BasicDiagnostic(4, Integer.toString(featureId), 10004, NLS.bind((String)Messages.Validator_duplicate_trigger_events, (Object[])new Object[]{trigger.getName(), otherTrigger.getName()}), new Object[]{trigger, otherTrigger});
                diagnostics.add(d2);
                break;
            }
        }
        return isValid;
    }

    private int getTriggerEventType(Trigger trigger) {
        int triggerType = 0;
        triggerType = trigger.isInsertType() ? triggerType | 1 : triggerType;
        triggerType = trigger.isDeleteType() ? triggerType | 2 : triggerType;
        triggerType = trigger.isUpdateType() ? triggerType | 4 : triggerType;
        triggerType = ((SybaseASABaseTrigger)trigger).isUpdateColumnType() ? 8 : triggerType;
        return triggerType;
    }

    protected boolean validateReference(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid = true;
        Trigger trigger = (Trigger)eObject;
        if (featureId == 9) {
            if (trigger.getSubjectTable() == null) {
                isValid = false;
                BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(9), 10002, NLS.bind((String)Messages.Validator_No_trigger_table, (Object)trigger.getName()), new Object[]{trigger});
                diagnostics.add((Diagnostic)d);
            }
        } else if (featureId == 11 && ((SybaseASABaseTrigger)trigger).isUpdateColumnType() && (trigger.getTriggerColumn() == null || trigger.getTriggerColumn().isEmpty())) {
            isValid = false;
            BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(11), 10005, NLS.bind((String)Messages.Validator_No_trigger_column, (Object)trigger.getName()), new Object[]{trigger});
            diagnostics.add((Diagnostic)d);
        }
        return isValid;
    }
}

