/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.script.Bindings;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RuntimeExtension.class}, property={"org.apache.sling.scripting.sightly.extension.name=i18n"})
public class I18nRuntimeExtension
implements RuntimeExtension {
    private static final Logger LOG = LoggerFactory.getLogger(I18nRuntimeExtension.class);
    private volatile boolean logged;

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("i18n", arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String text = runtimeObjectModel.toString(arguments[0]);
        Map options = (Map)arguments[1];
        String locale = runtimeObjectModel.toString(options.get("locale"));
        String hint = runtimeObjectModel.toString(options.get("hint"));
        String basename = runtimeObjectModel.toString(options.get("basename"));
        Bindings bindings = renderContext.getBindings();
        return this.get(bindings, text, locale, basename, hint);
    }

    private Object getResourceBundleProvider(SlingScriptHelper slingScriptHelper) {
        Class<?> clazz;
        try {
            clazz = this.getClass().getClassLoader().loadClass("org.apache.sling.i18n.ResourceBundleProvider");
        }
        catch (Throwable t) {
            if (!this.logged) {
                LOG.warn("i18n package not available");
                this.logged = true;
            }
            return null;
        }
        return slingScriptHelper.getService(clazz);
    }

    private String get(Bindings bindings, String text, String locale, String basename, String hint) {
        SlingScriptHelper slingScriptHelper = BindingsUtils.getHelper(bindings);
        SlingJakartaHttpServletRequest request = BindingsUtils.getJakartaRequest(bindings);
        Object resourceBundleProvider = this.getResourceBundleProvider(slingScriptHelper);
        if (resourceBundleProvider != null) {
            Object key = text;
            if (StringUtils.isNotEmpty((CharSequence)hint)) {
                key = (String)key + " ((" + hint + "))";
            }
            if (StringUtils.isEmpty((CharSequence)locale)) {
                Enumeration requestLocales = request.getLocales();
                while (requestLocales.hasMoreElements()) {
                    Locale l = (Locale)requestLocales.nextElement();
                    String translation = this.getTranslation(resourceBundleProvider, basename, (String)key, l);
                    if (translation == null) continue;
                    return translation;
                }
            } else {
                try {
                    Locale l = LocaleUtils.toLocale((String)locale);
                    String translation = this.getTranslation(resourceBundleProvider, basename, (String)key, l);
                    if (translation != null) {
                        return translation;
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Invalid locale detected: {}.", (Object)locale);
                    return text;
                }
            }
        }
        LOG.warn("No translation found for string '{}' using expression provided locale '{}' or default locale '{}'", new Object[]{text, locale, request.getLocale().getLanguage()});
        return text;
    }

    private String getTranslation(Object resourceBundleProvider, String basename, String key, Locale locale) {
        ResourceBundle resourceBundle = StringUtils.isNotEmpty((CharSequence)basename) ? ((ResourceBundleProvider)resourceBundleProvider).getResourceBundle(basename, locale) : ((ResourceBundleProvider)resourceBundleProvider).getResourceBundle(locale);
        if (resourceBundle != null && resourceBundle.containsKey(key)) {
            return resourceBundle.getString(key);
        }
        return null;
    }
}

