/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.helper;

import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.sling.jcr.webdav.impl.helper.SlingLocatorFactory;

class SlingResourceLocator
implements DavResourceLocator {
    private final String prefix;
    private final String workspaceName;
    private final String resourcePath;
    private final SlingLocatorFactory factory;
    private final String href;

    SlingResourceLocator(String prefix, String workspaceName, String resourcePath, SlingLocatorFactory factory) {
        this.prefix = prefix;
        this.workspaceName = workspaceName;
        this.resourcePath = resourcePath;
        this.factory = factory;
        StringBuffer buf = new StringBuffer(prefix);
        buf.append(Text.escapePath((String)resourcePath));
        int length = buf.length();
        if (length > 0 && buf.charAt(length - 1) != '/') {
            buf.append("/");
        }
        this.href = buf.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getWorkspacePath() {
        return "/" + this.workspaceName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public boolean isSameWorkspace(DavResourceLocator locator) {
        return locator == null ? false : this.isSameWorkspace(locator.getWorkspaceName());
    }

    public boolean isSameWorkspace(String workspaceName) {
        String thisWspName = this.getWorkspaceName();
        return thisWspName == null ? workspaceName == null : thisWspName.equals(workspaceName);
    }

    public String getHref(boolean isCollection) {
        return isCollection ? this.href : this.href.substring(0, this.href.length() - 1);
    }

    public boolean isRootLocation() {
        return this.getWorkspacePath() == null;
    }

    public DavLocatorFactory getFactory() {
        return this.factory;
    }

    public String getRepositoryPath() {
        return this.getResourcePath();
    }

    public int hashCode() {
        return this.href.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SlingResourceLocator) {
            SlingResourceLocator other = (SlingResourceLocator)obj;
            return this.hashCode() == other.hashCode();
        }
        return false;
    }
}

