/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import jakarta.servlet.Servlet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.jcr.jackrabbit.accessmanager.DeleteAces;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessPostServlet;
import org.apache.sling.servlets.post.JakartaPostResponse;
import org.apache.sling.servlets.post.JakartaPostResponseCreator;
import org.apache.sling.servlets.post.Modification;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, DeleteAces.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=POST", "sling.servlet.selectors=deleteAce", "sling.servlet.prefix:Integer=-1"}, reference={@Reference(name="PostResponseCreator", bind="bindPostResponseCreator", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=JakartaPostResponseCreator.class)})
public class DeleteAcesServlet
extends AbstractAccessPostServlet
implements DeleteAces {
    private static final long serialVersionUID = 3784866802938282971L;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void handleOperation(SlingJakartaHttpServletRequest request, JakartaPostResponse htmlResponse, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String resourcePath = this.getItemPath(request);
        String[] applyTo = request.getParameterValues(":applyTo");
        this.deleteAces(session, resourcePath, applyTo, changes);
    }

    @Override
    public void deleteAces(Session jcrSession, String resourcePath, String[] principalNamesToDelete) throws RepositoryException {
        this.deleteAces(jcrSession, resourcePath, principalNamesToDelete, null);
    }

    @NotNull
    protected Set<Principal> validateArgs(Session jcrSession, String resourcePath, String[] principalNamesToDelete) throws RepositoryException {
        HashSet<Principal> found = new HashSet<Principal>();
        if (principalNamesToDelete == null) {
            throw new RepositoryException("principalIds were not sumitted.");
        }
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        this.validateResourcePath(jcrSession, resourcePath);
        PrincipalManager principalManager = ((JackrabbitSession)jcrSession).getPrincipalManager();
        for (String pid : principalNamesToDelete) {
            Principal principal = principalManager.getPrincipal(pid);
            if (principal == null) {
                throw new RepositoryException("Invalid principalId was submitted.");
            }
            found.add(principal);
        }
        return found;
    }

    protected void deleteAces(Session jcrSession, String resourcePath, String[] principalNamesToDelete, List<Modification> changes) throws RepositoryException {
        @NotNull Set<Principal> found = this.validateArgs(jcrSession, resourcePath, principalNamesToDelete);
        try {
            AccessControlManager accessControlManager = jcrSession.getAccessControlManager();
            AccessControlList updatedAcl = this.getAccessControlListOrNull(accessControlManager, resourcePath, false);
            if (updatedAcl == null) {
                for (Principal principal : found) {
                    this.log.warn("No AccessControlEntry was found to be deleted for principal: {}", (Object)principal.getName());
                }
            } else {
                AccessControlEntry[] accessControlEntries = updatedAcl.getAccessControlEntries();
                ArrayList<AccessControlEntry> oldAces = new ArrayList<AccessControlEntry>();
                for (AccessControlEntry ace : accessControlEntries) {
                    if (!found.contains(ace.getPrincipal())) continue;
                    oldAces.add(ace);
                }
                HashSet<Principal> removedPrincipalSet = new HashSet<Principal>();
                if (!oldAces.isEmpty()) {
                    for (AccessControlEntry ace : oldAces) {
                        updatedAcl.removeAccessControlEntry(ace);
                        removedPrincipalSet.add(ace.getPrincipal());
                    }
                }
                for (Principal principal : found) {
                    if (removedPrincipalSet.contains(principal)) {
                        if (changes == null) continue;
                        changes.add(Modification.onDeleted((String)principal.getName()));
                        continue;
                    }
                    this.log.warn("No AccessControlEntry was found to be deleted for principal: {}", (Object)principal.getName());
                }
                accessControlManager.setPolicy(resourcePath, (AccessControlPolicy)updatedAcl);
            }
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to delete access control.", (Throwable)re);
        }
    }
}

