/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.caconfig.impl.metadata.AnnotationClassParser;
import org.apache.sling.caconfig.impl.metadata.ConfigurationMapping;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BundleConfigurationMapping {
    private final Bundle bundle;
    private final String classNamesList;
    private final AtomicReference<Map<String, ConfigurationMapping>> configMappingsRef = new AtomicReference<Object>(null);
    private static final Logger log = LoggerFactory.getLogger(BundleConfigurationMapping.class);

    public BundleConfigurationMapping(Bundle bundle, String classNamesList) {
        this.bundle = bundle;
        this.classNamesList = classNamesList;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    private Map<String, ConfigurationMapping> getConfigMappings() {
        Map<String, ConfigurationMapping> configMappings = this.configMappingsRef.get();
        if (configMappings == null) {
            configMappings = this.initializeConfigMappings();
            if (this.configMappingsRef.compareAndSet(null, configMappings)) {
                return configMappings;
            }
            return this.configMappingsRef.get();
        }
        return configMappings;
    }

    private Map<String, ConfigurationMapping> initializeConfigMappings() {
        String[] classNames;
        HashMap<String, ConfigurationMapping> configMappings = new HashMap<String, ConfigurationMapping>();
        for (String className : classNames = StringUtils.split((String)StringUtils.deleteWhitespace((String)this.classNamesList), (String)",")) {
            try {
                Class configClass = this.bundle.loadClass(className);
                if (AnnotationClassParser.isContextAwareConfig(configClass)) {
                    log.debug("{}: Add configuration class {}", (Object)this.bundle.getSymbolicName(), (Object)className);
                    ConfigurationMapping configMapping = new ConfigurationMapping(configClass);
                    if (this.hasMappingConflict(configMapping, configMappings)) continue;
                    configMappings.put(configMapping.getConfigName(), configMapping);
                    continue;
                }
                log.warn("Ignoring invalid configuration class: {}", (Object)className);
            }
            catch (ClassNotFoundException ex) {
                log.warn("Unable to load class: " + className, (Throwable)ex);
            }
        }
        return configMappings;
    }

    private boolean hasMappingConflict(ConfigurationMapping newConfigMapping, Map<String, ConfigurationMapping> configMappings) {
        ConfigurationMapping conflictingConfigMapping = configMappings.get(newConfigMapping.getConfigName());
        if (conflictingConfigMapping != null) {
            log.warn("Configuration name conflict in bundle {}: Both configuration classes {} and {} define the configuration name '{}', ignoring the latter.", new Object[]{this.bundle.getSymbolicName(), conflictingConfigMapping.getConfigClass().getName(), newConfigMapping.getConfigClass().getName(), newConfigMapping.getConfigName()});
            return true;
        }
        return false;
    }

    public Set<String> getConfigurationNames() {
        return this.getConfigMappings().keySet();
    }

    public ConfigurationMapping getConfigurationMapping(String configName) {
        return this.getConfigMappings().get(configName);
    }

    public String toString() {
        return "Classes from bundle '" + this.bundle.getSymbolicName() + "': " + this.classNamesList;
    }
}

