/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.PlatformHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.common.rest.RestProducerInvocationFlow;
import org.apache.servicecomb.common.rest.route.URLMappedConfigurationItem;
import org.apache.servicecomb.common.rest.route.URLMappedConfigurationLoader;
import org.apache.servicecomb.common.rest.route.Utils;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.edge.core.AbstractEdgeDispatcher;
import org.apache.servicecomb.edge.core.EdgeInvocationCreator;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.VertxServerRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.VertxServerResponseToHttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class URLMappedEdgeDispatcher
extends AbstractEdgeDispatcher {
    public static final String CONFIGURATION_ITEM = "URLMappedConfigurationItem";
    private static final String PATTERN_ANY = "/(.*)";
    private static final String KEY_ORDER = "servicecomb.http.dispatcher.edge.url.order";
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.edge.url.enabled";
    private static final String KEY_PATTERN = "servicecomb.http.dispatcher.edge.url.pattern";
    private static final String KEY_MAPPING_PREFIX = "servicecomb.http.dispatcher.edge.url.mappings";
    private Map<String, URLMappedConfigurationItem> configurations = new HashMap<String, URLMappedConfigurationItem>();
    private Environment environment;

    public URLMappedEdgeDispatcher() {
        EventManager.register((Object)((Object)this));
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
        if (this.enabled()) {
            this.loadConfigurations();
        }
    }

    @VisibleForTesting
    public Map<String, URLMappedConfigurationItem> getConfigurations() {
        return this.configurations;
    }

    public int getOrder() {
        return LegacyPropertyFactory.getIntProperty((String)KEY_ORDER, (int)30000);
    }

    public boolean enabled() {
        return (Boolean)this.environment.getProperty(KEY_ENABLED, Boolean.TYPE, (Object)false);
    }

    public void init(Router router) {
        String pattern = this.environment.getProperty(KEY_PATTERN, PATTERN_ANY);
        router.routeWithRegex(pattern).failureHandler(this::onFailure).handler((Handler)((PlatformHandler)this::preCheck)).handler((Handler)this.createBodyHandler()).handler(this::onRequest);
    }

    private void loadConfigurations() {
        this.configurations = URLMappedConfigurationLoader.loadConfigurations((Environment)this.environment, (String)KEY_MAPPING_PREFIX);
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        for (String changed : event.getChanged()) {
            if (!changed.startsWith(KEY_MAPPING_PREFIX)) continue;
            this.loadConfigurations();
            break;
        }
    }

    protected void preCheck(RoutingContext context) {
        URLMappedConfigurationItem configurationItem = this.findConfigurationItem(context.request().path());
        if (configurationItem == null) {
            context.put("__bypass_body_handler", (Object)Boolean.TRUE);
            context.next();
            return;
        }
        context.put(CONFIGURATION_ITEM, (Object)configurationItem);
        context.next();
    }

    protected void onRequest(RoutingContext context) {
        Boolean bypass = (Boolean)context.get("__bypass_body_handler");
        if (Boolean.TRUE.equals(bypass)) {
            context.put("__bypass_body_handler", (Object)Boolean.FALSE);
            context.next();
            return;
        }
        URLMappedConfigurationItem configurationItem = (URLMappedConfigurationItem)context.get(CONFIGURATION_ITEM);
        String path = Utils.findActualPath((String)context.request().path(), (int)configurationItem.getPrefixSegmentCount());
        this.requestByFilter(context, configurationItem, path);
    }

    protected void requestByFilter(RoutingContext context, URLMappedConfigurationItem configurationItem, String path) {
        VertxServerRequestToHttpServletRequest requestEx = new VertxServerRequestToHttpServletRequest(context);
        VertxServerResponseToHttpServletResponse responseEx = new VertxServerResponseToHttpServletResponse(context.response());
        EdgeInvocationCreator creator = new EdgeInvocationCreator(context, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx, configurationItem.getMicroserviceName(), path);
        new RestProducerInvocationFlow((InvocationCreator)creator, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx).run();
    }

    private URLMappedConfigurationItem findConfigurationItem(String path) {
        for (URLMappedConfigurationItem item : this.configurations.values()) {
            if (!item.getPattern().matcher(path).matches()) continue;
            return item;
        }
        return null;
    }
}

