/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.spring.beans.wizards;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;

/**
 *
 * @author  Rohan Ranade (Rohan.Ranade@Sun.COM)
 */
public class SpringXMLConfigGroupVisual extends javax.swing.JPanel {
    
    /** Creates new form SpringXMLConfigGroupVisual */
    public SpringXMLConfigGroupVisual(List<ConfigFileGroup> configFileGroups) {
        initComponents();
        groupsTable.getParent().setBackground(groupsTable.getBackground());
        groupsTable.setModel(new ConfigGroupSelectionTableModel(configFileGroups));
        groupsTable.getColumnModel().getColumn(0).setMaxWidth(0);
        groupsTable.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        groupsScrollPane = new javax.swing.JScrollPane();
        groupsTable = new javax.swing.JTable();
        groupsLabel = new javax.swing.JLabel();

        groupsTable.setIntercellSpacing(new java.awt.Dimension(0, 0));
        groupsTable.setShowHorizontalLines(false);
        groupsTable.setShowVerticalLines(false);
        groupsTable.setTableHeader(null);
        groupsScrollPane.setViewportView(groupsTable);

        groupsLabel.setText(org.openide.util.NbBundle.getMessage(SpringXMLConfigGroupVisual.class, "LBL_Config_File_Selection")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(groupsLabel)
                .addContainerGap(152, Short.MAX_VALUE))
            .addComponent(groupsScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 431, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(groupsLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(groupsScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 193, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel groupsLabel;
    private javax.swing.JScrollPane groupsScrollPane;
    private javax.swing.JTable groupsTable;
    // End of variables declaration//GEN-END:variables
    
    
    public Set<ConfigFileGroup> getSelectedConfigFileGroups() {
        return ((ConfigGroupSelectionTableModel)groupsTable.getModel()).getSelectedGroups();
    }
    
    private static final class ConfigGroupSelectionTableModel implements TableModel {
        
        private List<ConfigFileGroup> groups;
        private boolean[] selected;

        public ConfigGroupSelectionTableModel(List<ConfigFileGroup> groups) {
            this.groups = groups;
            selected = new boolean[groups.size()];
        }

        public int getRowCount() {
            return groups.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            return ""; // NOI18N
        }

        public Class<?> getColumnClass(int columnIndex) {
            return (columnIndex == 0) ? Boolean.class : ConfigFileGroup.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return (columnIndex == 0) ? selected[rowIndex] : groups.get(rowIndex).getName();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            selected[rowIndex] = (Boolean)aValue;
        }

        public void addTableModelListener(TableModelListener l) {
        }

        public void removeTableModelListener(TableModelListener l) {
        }
        
        public Set<ConfigFileGroup> getSelectedGroups() {
            Set<ConfigFileGroup> selectedGroups = new HashSet<ConfigFileGroup>(groups.size());
            for (int i = 0; i < groups.size(); i++) {
                if (selected[i]) {
                    selectedGroups.add(groups.get(i));
                }
            }
            
            return selectedGroups;
        }
    }
}
