/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import javax.swing.JComponent;

/**
 *
 * @author Andrei Badea
 */
public class GrabTableProgressPanel extends javax.swing.JPanel {

    public GrabTableProgressPanel() {
        initComponents();
    }

    public void setProgressComponent(JComponent component) {
        progressPlaceHolderPanel.removeAll();
        progressPlaceHolderPanel.add(component, BorderLayout.CENTER);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        messageLabel = new javax.swing.JLabel();
        progressPlaceHolderPanel = new javax.swing.JPanel();

        messageLabel.setText(org.openide.util.NbBundle.getMessage(GrabTableProgressPanel.class, "GrabTableProgressDialogMessage")); // NOI18N

        progressPlaceHolderPanel.setLayout(new java.awt.BorderLayout());

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(messageLabel)
                    .addComponent(progressPlaceHolderPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(messageLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(progressPlaceHolderPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(18, Short.MAX_VALUE))
        );

        messageLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(GrabTableProgressPanel.class, "GrabTableProgressDialogMessage")); // NOI18N
        messageLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(GrabTableProgressPanel.class, "GrabTableProgressDialogMessage")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JLabel messageLabel;
    public javax.swing.JPanel progressPlaceHolderPanel;
    // End of variables declaration//GEN-END:variables
    
}
