/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.util.FunctionalUtils;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class DSNFailureRequested
extends GenericMatcher {
    private static final boolean DEFAULT_PRESENT = true;
    public static final String CONDITION = "shouldNotMatchByDefault";
    private boolean shouldBeMatchedByDefault;

    public void init() throws MessagingException {
        Preconditions.checkState((Strings.isNullOrEmpty((String)this.getCondition()) || CONDITION.equals(this.getCondition()) ? 1 : 0) != 0, (String)"DSNFailureRequested condition, when specified, should be '%s'", (Object)CONDITION);
        this.shouldBeMatchedByDefault = Optional.ofNullable(this.getCondition()).map(CONDITION::equals).map(FunctionalUtils.negate()).orElse(true);
    }

    public Collection<MailAddress> match(Mail mail) {
        return (Collection)mail.getRecipients().stream().filter(recipient -> this.failureRequested(mail, (MailAddress)recipient)).collect(ImmutableList.toImmutableList());
    }

    private Boolean failureRequested(Mail mail, MailAddress recipient) {
        return mail.dsnParameters().map(dsnParameters -> this.failureRequested(recipient, (DsnParameters)dsnParameters)).orElse(this.shouldBeMatchedByDefault);
    }

    private boolean failureRequested(MailAddress recipient, DsnParameters dsnParameters) {
        return Optional.ofNullable((DsnParameters.RecipientDsnParameters)dsnParameters.getRcptParameters().get((Object)recipient)).map(rcptParams -> rcptParams.getNotifyParameter().map(notifies -> notifies.contains(DsnParameters.Notify.FAILURE)).orElse(this.shouldBeMatchedByDefault)).orElse(this.shouldBeMatchedByDefault);
    }

    public String getMatcherName() {
        return "DSNFailureRequested";
    }
}

