/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.main.ResponseEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImapRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractImapRequestHandler.class);
    protected static final byte[] ABANDON_SIGNOFF = new byte[]{42, 32, 66, 89, 69, 32, 65, 98, 97, 110, 100, 111, 110, 101, 100, 13, 10};
    protected static final byte[] MAILBOX_DELETED_SIGNOFF = new byte[]{42, 32, 66, 89, 69, 32, 83, 101, 108, 101, 99, 116, 101, 100, 32, 109, 97, 105, 108, 98, 111, 120, 32, 104, 97, 115, 32, 98, 101, 101, 110, 32, 100, 101, 108, 101, 116, 101, 100, 13, 10};
    private final ImapDecoder decoder;
    protected final ImapProcessor processor;
    private final ImapEncoder encoder;

    public AbstractImapRequestHandler(ImapDecoder decoder, ImapProcessor processor, ImapEncoder encoder) {
        this.decoder = decoder;
        this.processor = processor;
        this.encoder = encoder;
    }

    protected boolean doProcessRequest(ImapRequestLineReader request, ImapResponseComposer response, ImapSession session) {
        boolean result;
        ImapMessage message = this.decoder.decode(request, session);
        ResponseEncoder responseEncoder = new ResponseEncoder(this.encoder, response);
        this.processor.process(message, responseEncoder, session);
        IOException failure = responseEncoder.getFailure();
        if (failure == null) {
            result = true;
        } else {
            result = false;
            LOGGER.info(failure.getMessage());
            LOGGER.debug("Failed to write {}", (Object)message, (Object)failure);
        }
        return result;
    }

    protected boolean isSelectedMailboxDeleted(ImapSession session) {
        SelectedMailbox mailbox = session.getSelected();
        boolean selectedMailboxIsDeleted = mailbox != null ? mailbox.isDeletedByOtherSession() : false;
        return selectedMailboxIsDeleted;
    }

    public static final class SilentResponder
    implements ImapProcessor.Responder {
        @Override
        public void respond(ImapResponseMessage message) {
        }

        @Override
        public void flush() {
        }
    }
}

