/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.ExternallyTaggedUnion;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.NamedDeserializer;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ClusterStatistics;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.opensearch.core.search.Profile;
import org.opensearch.client.opensearch.core.search.Suggestion;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SearchResponse<TDocument>
implements JsonpSerializable {
    private final long took;
    private final boolean timedOut;
    private final ShardStatistics shards;
    private final HitsMetadata<TDocument> hits;
    private final Map<String, Aggregate> aggregations;
    @Nullable
    private final ClusterStatistics clusters;
    private final List<TDocument> documents;
    private final Map<String, JsonData> fields;
    @Nullable
    private final Double maxScore;
    @Nullable
    private final Long numReducePhases;
    @Nullable
    private final Profile profile;
    @Nullable
    private final String pitId;
    @Nullable
    private final String scrollId;
    private final Map<String, List<Suggestion<TDocument>>> suggest;
    @Nullable
    private final Boolean terminatedEarly;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<SearchResponse<Object>> _DESERIALIZER = SearchResponse.createSearchResponseDeserializer(new NamedDeserializer("org.opensearch.client:Deserializer:_global.search.TDocument"));

    protected SearchResponse(AbstractBuilder<TDocument, ?> builder) {
        this.took = ApiTypeHelper.requireNonNull(builder.took, this, "took");
        this.timedOut = ApiTypeHelper.requireNonNull(builder.timedOut, this, "timedOut");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, this, "hits");
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.clusters = builder.clusters;
        this.documents = ApiTypeHelper.unmodifiable(builder.documents);
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.maxScore = builder.maxScore;
        this.numReducePhases = builder.numReducePhases;
        this.profile = builder.profile;
        this.pitId = builder.pitId;
        this.scrollId = builder.scrollId;
        this.suggest = ApiTypeHelper.unmodifiable(builder.suggest);
        this.terminatedEarly = builder.terminatedEarly;
        this.tDocumentSerializer = builder.tDocumentSerializer;
    }

    public static <TDocument> SearchResponse<TDocument> searchResponseOf(Function<Builder<TDocument>, ObjectBuilder<SearchResponse<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long took() {
        return this.took;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    public final Map<String, Aggregate> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final ClusterStatistics clusters() {
        return this.clusters;
    }

    public final List<TDocument> documents() {
        return this.documents;
    }

    public final Map<String, JsonData> fields() {
        return this.fields;
    }

    @Nullable
    public final Double maxScore() {
        return this.maxScore;
    }

    @Nullable
    public final Long numReducePhases() {
        return this.numReducePhases;
    }

    @Nullable
    public final Profile profile() {
        return this.profile;
    }

    @Nullable
    public final String pitId() {
        return this.pitId;
    }

    @Nullable
    public final String scrollId() {
        return this.scrollId;
    }

    public final Map<String, List<Suggestion<TDocument>>> suggest() {
        return this.suggest;
    }

    @Nullable
    public final Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            ExternallyTaggedUnion.serializeTypedKeys(this.aggregations, generator, mapper);
        }
        if (this.clusters != null) {
            generator.writeKey("_clusters");
            this.clusters.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.documents)) {
            generator.writeKey("documents");
            generator.writeStartArray();
            for (TDocument TDocument : this.documents) {
                JsonpUtils.serialize(TDocument, generator, this.tDocumentSerializer, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.fields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
        if (this.numReducePhases != null) {
            generator.writeKey("num_reduce_phases");
            generator.write(this.numReducePhases.longValue());
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            this.profile.serialize(generator, mapper);
        }
        if (this.pitId != null) {
            generator.writeKey("pit_id");
            generator.write(this.pitId);
        }
        if (this.scrollId != null) {
            generator.writeKey("_scroll_id");
            generator.write(this.scrollId);
        }
        if (ApiTypeHelper.isDefined(this.suggest)) {
            generator.writeKey("suggest");
            generator.writeStartObject();
            for (Map.Entry entry : this.suggest.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (Suggestion item1 : (List)entry.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.terminatedEarly != null) {
            generator.writeKey("terminated_early");
            generator.write(this.terminatedEarly.booleanValue());
        }
    }

    public static <TDocument> JsonpDeserializer<SearchResponse<TDocument>> createSearchResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> SearchResponse.setupSearchResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>> void setupSearchResponseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(AbstractBuilder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(AbstractBuilder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(AbstractBuilder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits");
        op.add(AbstractBuilder::aggregations, Aggregate._TYPED_KEYS_DESERIALIZER, "aggregations");
        op.add(AbstractBuilder::clusters, ClusterStatistics._DESERIALIZER, "_clusters");
        op.add(AbstractBuilder::documents, JsonpDeserializer.arrayDeserializer(tDocumentDeserializer), "documents");
        op.add(AbstractBuilder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields");
        op.add(AbstractBuilder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score");
        op.add(AbstractBuilder::numReducePhases, JsonpDeserializer.longDeserializer(), "num_reduce_phases");
        op.add(AbstractBuilder::profile, Profile._DESERIALIZER, "profile");
        op.add(AbstractBuilder::pitId, JsonpDeserializer.stringDeserializer(), "pit_id");
        op.add(AbstractBuilder::scrollId, JsonpDeserializer.stringDeserializer(), "_scroll_id");
        op.add(AbstractBuilder::suggest, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(Suggestion.createSuggestionDeserializer(tDocumentDeserializer))), "suggest");
        op.add(AbstractBuilder::terminatedEarly, JsonpDeserializer.booleanDeserializer(), "terminated_early");
    }

    protected static abstract class AbstractBuilder<TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>>
    extends ObjectBuilderBase {
        private Long took;
        private Boolean timedOut;
        private ShardStatistics shards;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private Map<String, Aggregate> aggregations;
        @Nullable
        private ClusterStatistics clusters;
        @Nullable
        private List<TDocument> documents;
        @Nullable
        private Map<String, JsonData> fields;
        @Nullable
        private Double maxScore;
        @Nullable
        private Long numReducePhases;
        @Nullable
        private Profile profile;
        @Nullable
        private String pitId;
        @Nullable
        private String scrollId;
        @Nullable
        private Map<String, List<Suggestion<TDocument>>> suggest;
        @Nullable
        private Boolean terminatedEarly;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        protected AbstractBuilder() {
        }

        public final BuilderT took(long value) {
            this.took = value;
            return this.self();
        }

        public final BuilderT timedOut(boolean value) {
            this.timedOut = value;
            return this.self();
        }

        public final BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return this.self();
        }

        public final BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final BuilderT hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return this.self();
        }

        public final BuilderT hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public final BuilderT aggregations(Map<String, Aggregate> map) {
            this.aggregations = AbstractBuilder._mapPutAll(this.aggregations, map);
            return this.self();
        }

        public final BuilderT aggregations(String key, Aggregate value) {
            this.aggregations = AbstractBuilder._mapPut(this.aggregations, key, value);
            return this.self();
        }

        public final BuilderT aggregations(String key, Function<Aggregate.Builder, ObjectBuilder<Aggregate>> fn) {
            return this.aggregations(key, fn.apply(new Aggregate.Builder()).build());
        }

        public final BuilderT clusters(@Nullable ClusterStatistics value) {
            this.clusters = value;
            return this.self();
        }

        public final BuilderT clusters(Function<ClusterStatistics.Builder, ObjectBuilder<ClusterStatistics>> fn) {
            return this.clusters(fn.apply(new ClusterStatistics.Builder()).build());
        }

        public final BuilderT documents(List<TDocument> list) {
            this.documents = AbstractBuilder._listAddAll(this.documents, list);
            return this.self();
        }

        public final BuilderT documents(TDocument value, TDocument ... values) {
            this.documents = AbstractBuilder._listAdd(this.documents, value, values);
            return this.self();
        }

        public final BuilderT fields(Map<String, JsonData> map) {
            this.fields = AbstractBuilder._mapPutAll(this.fields, map);
            return this.self();
        }

        public final BuilderT fields(String key, JsonData value) {
            this.fields = AbstractBuilder._mapPut(this.fields, key, value);
            return this.self();
        }

        public final BuilderT maxScore(@Nullable Double value) {
            this.maxScore = value;
            return this.self();
        }

        public final BuilderT numReducePhases(@Nullable Long value) {
            this.numReducePhases = value;
            return this.self();
        }

        public final BuilderT profile(@Nullable Profile value) {
            this.profile = value;
            return this.self();
        }

        public final BuilderT profile(Function<Profile.Builder, ObjectBuilder<Profile>> fn) {
            return this.profile(fn.apply(new Profile.Builder()).build());
        }

        public final BuilderT pitId(@Nullable String value) {
            this.pitId = value;
            return this.self();
        }

        public final BuilderT scrollId(@Nullable String value) {
            this.scrollId = value;
            return this.self();
        }

        public final BuilderT suggest(Map<String, List<Suggestion<TDocument>>> map) {
            this.suggest = AbstractBuilder._mapPutAll(this.suggest, map);
            return this.self();
        }

        public final BuilderT suggest(String key, List<Suggestion<TDocument>> value) {
            this.suggest = AbstractBuilder._mapPut(this.suggest, key, value);
            return this.self();
        }

        public final BuilderT terminatedEarly(@Nullable Boolean value) {
            this.terminatedEarly = value;
            return this.self();
        }

        public final BuilderT tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder<TDocument>
    extends AbstractBuilder<TDocument, Builder<TDocument>>
    implements ObjectBuilder<SearchResponse<TDocument>> {
        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public SearchResponse<TDocument> build() {
            this._checkSingleUse();
            return new SearchResponse(this);
        }
    }
}

