/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kson;

import java.util.Stack;
import org.nustaq.kson.KsonCharInput;
import org.nustaq.kson.KsonDeserializer;

public class KsonStringCharInput
implements KsonCharInput {
    CharSequence s;
    int pos;
    int end;
    Stack<KsonDeserializer.ParseStep> stack;

    public KsonStringCharInput(CharSequence s2) {
        this.s = s2;
        this.pos = 0;
        this.end = s2.length();
    }

    public KsonStringCharInput(String s2, int pos, int len) {
        this.s = s2;
        this.pos = pos;
        this.end = pos + len;
    }

    @Override
    public int readChar() {
        if (this.pos >= this.end) {
            return -1;
        }
        return this.s.charAt(this.pos++);
    }

    @Override
    public int peekChar() {
        if (this.pos >= this.end) {
            return -1;
        }
        return this.s.charAt(this.pos);
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public int back(int num) {
        this.pos -= num;
        return this.pos;
    }

    @Override
    public boolean isEof() {
        return this.pos >= this.s.length();
    }

    @Override
    public String getString(int pos, int length) {
        return this.s.subSequence(Math.max(0, pos), Math.min(this.s.length(), pos + length)).toString();
    }
}

