/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.jmap.draft.exceptions.JmapFieldNotSupportedException;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.UpdateMessagePatchConverter;
import org.apache.james.jmap.draft.methods.ValueWithId;
import org.apache.james.jmap.draft.model.CreationMessage;
import org.apache.james.jmap.draft.model.CreationMessageId;
import org.apache.james.jmap.draft.model.JmapMDN;
import org.apache.james.jmap.draft.model.UpdateMessagePatch;
import org.apache.james.mailbox.model.MessageId;

@JsonDeserialize(builder=Builder.class)
public class SetMessagesRequest
implements JmapRequest {
    private static final String ISSUER = "SetMessagesRequest";
    private final Optional<String> accountId;
    private final Optional<String> ifInState;
    private final List<ValueWithId.CreationMessageEntry> create;
    private final List<ValueWithId.MDNCreationEntry> sendMDN;
    private final Map<MessageId, Function<UpdateMessagePatchConverter, UpdateMessagePatch>> update;
    private final List<MessageId> destroy;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    SetMessagesRequest(Optional<String> accountId, Optional<String> ifInState, List<ValueWithId.CreationMessageEntry> create, List<ValueWithId.MDNCreationEntry> sendMDN, Map<MessageId, Function<UpdateMessagePatchConverter, UpdateMessagePatch>> update, List<MessageId> destroy) {
        this.accountId = accountId;
        this.ifInState = ifInState;
        this.create = create;
        this.sendMDN = sendMDN;
        this.update = update;
        this.destroy = destroy;
    }

    public Optional<String> getAccountId() {
        return this.accountId;
    }

    public Optional<String> getIfInState() {
        return this.ifInState;
    }

    public List<ValueWithId.CreationMessageEntry> getCreate() {
        return this.create;
    }

    public List<ValueWithId.MDNCreationEntry> getSendMDN() {
        return this.sendMDN;
    }

    public Map<MessageId, UpdateMessagePatch> buildUpdatePatches(UpdateMessagePatchConverter converter) {
        return Maps.transformValues(this.update, func -> (UpdateMessagePatch)func.apply(converter));
    }

    public boolean hasUpdates() {
        return !this.update.isEmpty();
    }

    public List<MessageId> getDestroy() {
        return this.destroy;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private String accountId;
        private String ifInState;
        private HashMap<CreationMessageId, CreationMessage> create = new HashMap();
        private HashMap<CreationMessageId, JmapMDN> sendMDN = new HashMap();
        private ImmutableMap.Builder<MessageId, Function<UpdateMessagePatchConverter, UpdateMessagePatch>> updatesProvider = ImmutableMap.builder();
        private ImmutableList.Builder<MessageId> destroy = ImmutableList.builder();

        private Builder() {
        }

        public Builder accountId(String accountId) {
            if (accountId != null) {
                throw new JmapFieldNotSupportedException(SetMessagesRequest.ISSUER, "accountId");
            }
            return this;
        }

        public Builder ifInState(String ifInState) {
            if (ifInState != null) {
                throw new JmapFieldNotSupportedException(SetMessagesRequest.ISSUER, "ifInState");
            }
            return this;
        }

        public Builder create(CreationMessageId creationMessageId, CreationMessage creation) {
            this.create.put(creationMessageId, creation);
            return this;
        }

        public Builder create(Map<CreationMessageId, CreationMessage> creations) {
            this.create.putAll(creations);
            return this;
        }

        public Builder sendMDN(CreationMessageId creationMessageId, JmapMDN mdn) {
            this.sendMDN.put(creationMessageId, mdn);
            return this;
        }

        public Builder sendMDN(Map<CreationMessageId, JmapMDN> mdns) {
            this.sendMDN.putAll(mdns);
            return this;
        }

        public Builder update(Map<MessageId, ObjectNode> updates) {
            this.updatesProvider.putAll(Maps.transformValues(updates, json -> converter -> converter.fromJsonNode((ObjectNode)json)));
            return this;
        }

        public Builder destroy(List<MessageId> destroy) {
            this.destroy.addAll(destroy);
            return this;
        }

        public SetMessagesRequest build() {
            return new SetMessagesRequest(Optional.ofNullable(this.accountId), Optional.ofNullable(this.ifInState), (List<ValueWithId.CreationMessageEntry>)this.messageCreations(), (List<ValueWithId.MDNCreationEntry>)this.mdnSendings(), (Map<MessageId, Function<UpdateMessagePatchConverter, UpdateMessagePatch>>)this.updatesProvider.build(), (List<MessageId>)this.destroy.build());
        }

        private ImmutableList<ValueWithId.CreationMessageEntry> messageCreations() {
            return (ImmutableList)this.create.entrySet().stream().map(entry -> new ValueWithId.CreationMessageEntry((CreationMessageId)entry.getKey(), (CreationMessage)entry.getValue())).collect(ImmutableList.toImmutableList());
        }

        private ImmutableList<ValueWithId.MDNCreationEntry> mdnSendings() {
            return (ImmutableList)this.sendMDN.entrySet().stream().map(entry -> new ValueWithId.MDNCreationEntry((CreationMessageId)entry.getKey(), (JmapMDN)entry.getValue())).collect(ImmutableList.toImmutableList());
        }
    }
}

