/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.config.Ignite2ConfigurationUtils;
import org.apache.ignite.migrationtools.config.Ignite3ConfigurationUtils;
import org.apache.ignite.migrationtools.config.converters.ClientConnectorConverter;
import org.apache.ignite.migrationtools.config.converters.DataRegionConfigurationConverter;
import org.apache.ignite.migrationtools.config.converters.DiscoverySpiConverter;
import org.apache.ignite.migrationtools.config.converters.SslContextFactoryConverter;
import org.apache.ignite.migrationtools.config.loader.CustomBeanFactory;
import org.apache.ignite.migrationtools.config.registry.CombinedConfigRegistry;
import org.apache.ignite.migrationtools.config.registry.ConfigurationRegistryInterface;
import org.jetbrains.annotations.Nullable;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ConfigurationConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationConverter.class);
    private static List<org.apache.ignite.migrationtools.config.converters.ConfigurationConverter> converters = List.of(new DiscoverySpiConverter(), new SslContextFactoryConverter(), new ClientConnectorConverter(), new DataRegionConfigurationConverter());

    public static void convertConfigurationFile(File inputFile, File nodeCfgFile, File clusterCfgFile, boolean includeDefaults, @Nullable ClassLoader clientClassloader) throws Exception {
        HashSetValuedHashMap propertyTracker = new HashSetValuedHashMap();
        CustomBeanFactory beanFactory = new CustomBeanFactory((MultiValuedMap)propertyTracker);
        IgniteConfiguration igniteCfg = Ignite2ConfigurationUtils.loadIgnite2Configuration((Resource)new FileSystemResource(inputFile), (DefaultListableBeanFactory)beanFactory, (ClassLoader)clientClassloader);
        igniteCfg = ConfigurationConverter.spyIgniteConfiguration((MultiValuedMap<Object, Pair<PropertyDescriptor, BeanDefinition>>)propertyTracker, igniteCfg, IgniteConfiguration.class);
        CombinedConfigRegistry registry = Ignite3ConfigurationUtils.loadCombinedRegistry((Path)nodeCfgFile.toPath(), (Path)clusterCfgFile.toPath(), (boolean)includeDefaults);
        registry.onDefaultsPersisted().get(10L, TimeUnit.SECONDS);
        LOGGER.info("Finished loading configurations into memory");
        LOGGER.info("Starting to map configurations");
        for (org.apache.ignite.migrationtools.config.converters.ConfigurationConverter configurationConverter : converters) {
            configurationConverter.convert(igniteCfg, (ConfigurationRegistryInterface)registry);
        }
        for (Map.Entry entry : propertyTracker.asMap().entrySet()) {
            List propertyNames = ((Collection)entry.getValue()).stream().map(p -> ((PropertyDescriptor)p.getKey()).getName()).collect(Collectors.toList());
            LOGGER.warn("Could not convert properties: {} - {}", (Object)entry.getKey().getClass().getName(), propertyNames);
        }
        LOGGER.info("Finished mapping configurations. Waiting until files are written...");
        registry.stopAsync().join();
    }

    private static <T> T spyIgniteConfiguration(MultiValuedMap<Object, Pair<PropertyDescriptor, BeanDefinition>> propertyTracker, T obj, Class<T> klass) {
        return (T)Mockito.mock(klass, (MockSettings)Mockito.withSettings().spiedInstance(obj).defaultAnswer(ans -> {
            Method calledMethod = ans.getMethod();
            propertyTracker.get(obj).stream().filter(e -> Objects.equals(((PropertyDescriptor)e.getLeft()).getReadMethod(), calledMethod)).findFirst().ifPresent(e -> {
                LOGGER.info("Registered property access: {} - {}::{}", new Object[]{obj.hashCode(), ((PropertyDescriptor)e.getLeft()).getReadMethod(), calledMethod});
                propertyTracker.removeMapping(obj, e);
            });
            Object ret = ans.callRealMethod();
            if (ret != null && MockUtil.typeMockabilityOf(ret.getClass(), null).mockable()) {
                return ConfigurationConverter.spyIgniteConfiguration(propertyTracker, ret, ret.getClass());
            }
            return ret;
        }));
    }
}

