/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.transactions.TransactionChanges;
import org.apache.ignite.internal.processors.query.calcite.exec.AbstractCacheScan;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.IndexScan;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.jetbrains.annotations.Nullable;

public class IndexCountScan<Row>
extends AbstractCacheScan<Row> {
    private final InlineIndex idx;
    private final RelCollation collation;
    private final boolean notNull;

    public IndexCountScan(ExecutionContext<Row> ectx, GridCacheContext<?, ?> cctx, int[] parts, InlineIndex idx, RelCollation collation, boolean notNull) {
        super(ectx, cctx, parts);
        this.idx = idx;
        this.collation = collation;
        this.notNull = notNull;
    }

    @Override
    protected Iterator<Row> createIterator() {
        TransactionChanges txChanges;
        boolean[] skipCheck = new boolean[]{false};
        BPlusTree.TreeRowClosure<IndexRow, IndexRow> rowFilter = this.countRowFilter(skipCheck, this.notNull, this.idx);
        long cnt = 0L;
        if (!F.isEmpty(this.ectx.getQryTxEntries()) && !(txChanges = this.ectx.transactionChanges(this.cctx.cacheId(), this.parts, Function.identity(), null)).changedKeysEmpty()) {
            rowFilter = IndexCountScan.transactionAwareCountRowFilter(rowFilter, txChanges);
            cnt = IndexCountScan.countTransactionRows(this.notNull, this.idx, txChanges.newAndUpdatedEntries());
        }
        try {
            IndexingQueryFilterImpl filter = new IndexingQueryFilterImpl(this.cctx.kernalContext(), this.topVer, this.parts);
            for (int i = 0; i < this.idx.segmentsCount(); ++i) {
                cnt += this.idx.count(i, new IndexQueryContext((IndexingQueryFilter)filter, rowFilter));
                skipCheck[0] = false;
            }
            return Collections.singletonList(this.ectx.rowHandler().factory(Long.TYPE).create(cnt)).iterator();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Unable to count index records.", (Throwable)e);
        }
    }

    @Nullable
    private BPlusTree.TreeRowClosure<IndexRow, IndexRow> countRowFilter(final boolean[] skipCheck, boolean notNull, InlineIndex iidx) {
        boolean checkExpired;
        boolean bl = checkExpired = !this.cctx.config().isEagerTtl();
        if (notNull) {
            final boolean nullsFirst = ((RelFieldCollation)this.collation.getFieldCollations().get((int)0)).nullDirection == RelFieldCollation.NullDirection.FIRST;
            final BPlusTree.TreeRowClosure<IndexRow, IndexRow> notNullRowFilter = IndexScan.createNotNullRowFilter(iidx, checkExpired);
            return new BPlusTree.TreeRowClosure<IndexRow, IndexRow>(){

                public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
                    if (skipCheck[0] && !checkExpired) {
                        return nullsFirst;
                    }
                    boolean res = notNullRowFilter.apply(tree, io, pageAddr, idx);
                    if (res == nullsFirst) {
                        skipCheck[0] = true;
                    }
                    return res;
                }

                public IndexRow lastRow() {
                    return skipCheck[0] && !checkExpired ? null : (IndexRow)notNullRowFilter.lastRow();
                }
            };
        }
        return checkExpired ? IndexScan.createNotExpiredRowFilter() : null;
    }

    private static BPlusTree.TreeRowClosure<IndexRow, IndexRow> transactionAwareCountRowFilter(final BPlusTree.TreeRowClosure<IndexRow, IndexRow> rowFilter, final TransactionChanges<CacheDataRow> txChanges) {
        return new BPlusTree.TreeRowClosure<IndexRow, IndexRow>(){

            public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
                IndexRow row;
                if (rowFilter != null && !rowFilter.apply(tree, io, pageAddr, idx)) {
                    return false;
                }
                if (txChanges.changedKeysEmpty()) {
                    return true;
                }
                IndexRow indexRow = row = rowFilter == null ? null : (IndexRow)rowFilter.lastRow();
                if (row == null) {
                    row = (IndexRow)tree.getRow(io, pageAddr, idx);
                }
                return !txChanges.remove(row.cacheDataRow().key());
            }
        };
    }

    private static long countTransactionRows(boolean notNull, InlineIndex iidx, List<CacheDataRow> changedRows) {
        InlineIndexRowHandler rowHnd = iidx.segment(0).rowHandler();
        long cnt = 0L;
        for (CacheDataRow txRow : changedRows) {
            if (rowHnd.indexKey(0, txRow) == NullIndexKey.INSTANCE && notNull) continue;
            ++cnt;
        }
        return cnt;
    }
}

