/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.messaging;

import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public abstract class MessagingListenActor<T>
implements IgniteBiPredicate<UUID, T> {
    private static final long serialVersionUID = 0L;
    private boolean keepGoing = true;
    private UUID nodeId;
    @IgniteInstanceResource
    private transient Ignite ignite;
    @LoggerResource
    private transient IgniteLogger log;

    protected final Ignite ignite() {
        assert (this.ignite != null);
        return this.ignite;
    }

    @Override
    public final boolean apply(UUID nodeId, T rcvMsg) {
        block5: {
            assert (nodeId != null);
            assert (rcvMsg != null);
            if (!this.keepGoing) {
                return false;
            }
            this.nodeId = nodeId;
            try {
                this.receive(nodeId, rcvMsg);
            }
            catch (Throwable e) {
                this.onError(e);
                if (!(e instanceof Error)) break block5;
                throw (Error)e;
            }
        }
        return this.keepGoing;
    }

    protected void onError(Throwable e) {
        U.error(this.log, "Listener operation failed.", e);
        this.stop();
    }

    protected abstract void receive(UUID var1, T var2) throws Throwable;

    protected final void stop() {
        this.keepGoing = false;
    }

    protected final void stop(@Nullable Object respMsg) throws IgniteException {
        this.keepGoing = false;
        this.send(this.nodeId, respMsg);
    }

    protected final void skip() {
        this.checkReversing();
        this.keepGoing = true;
    }

    protected final void respond(@Nullable Object respMsg) throws IgniteException {
        this.checkReversing();
        this.keepGoing = true;
        this.send(this.nodeId, respMsg);
    }

    protected final void respond(UUID id, @Nullable Object respMsg) throws IgniteException {
        this.checkReversing();
        this.keepGoing = true;
        this.send(id, respMsg);
    }

    private void checkReversing() {
        if (!this.keepGoing) {
            U.warn(this.log, "Suspect logic - reversing listener return status (was 'true', then 'false', now 'true' again).");
        }
    }

    private void send(UUID nodeId, @Nullable Object respMsg) throws IgniteException {
        assert (nodeId != null);
        if (respMsg != null) {
            ClusterNode node = this.ignite.cluster().node(nodeId);
            if (node != null) {
                this.ignite.message(this.ignite.cluster().forNode(node, new ClusterNode[0])).send(null, respMsg);
            } else {
                throw new IgniteException("Failed to send message since destination node has left topology (ignoring) [nodeId=" + nodeId + ", respMsg=" + respMsg + "]");
            }
        }
    }

    public String toString() {
        return S.toString(MessagingListenActor.class, this);
    }
}

