/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.examples.echo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkServer;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.examples.echo.EchoBenchmarkArguments;

public class EchoServer
implements BenchmarkServer {
    private final EchoBenchmarkArguments args = new EchoBenchmarkArguments();
    private Thread th;

    @Override
    public void start(final BenchmarkConfiguration cfg) throws Exception {
        BenchmarkUtils.jcommander(cfg.commandLineArguments(), this.args, "<echo-server>");
        BenchmarkUtils.println("Started server with id: " + cfg.memberId());
        this.th = new Thread(new Runnable(){

            @Override
            public void run() {
                try (ServerSocket srvrSock = EchoServer.this.newServerSocket(EchoServer.this.args);){
                    while (!Thread.interrupted()) {
                        final Socket sock = srvrSock.accept();
                        Thread t = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    int b;
                                    InputStream in = sock.getInputStream();
                                    OutputStream out = sock.getOutputStream();
                                    while ((b = in.read()) > 0) {
                                        out.write(b);
                                    }
                                }
                                catch (IOException e) {
                                    BenchmarkUtils.errorHelp(cfg, "Exception is raised.", e);
                                }
                                finally {
                                    try {
                                        sock.close();
                                    }
                                    catch (IOException e) {
                                        BenchmarkUtils.errorHelp(cfg, "Exception is raised.", e);
                                    }
                                }
                            }
                        });
                        t.setDaemon(true);
                        t.start();
                    }
                }
                catch (IOException e) {
                    BenchmarkUtils.errorHelp(cfg, "Exception is raised.", e);
                }
            }
        });
        this.th.start();
    }

    private ServerSocket newServerSocket(EchoBenchmarkArguments args) throws IOException {
        IOException ex = null;
        for (int port = args.port(); port < args.port() + 10; ++port) {
            try {
                return new ServerSocket(port, 50, InetAddress.getByName(args.localBind()));
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (IOException e) {
                ex = e;
                continue;
            }
        }
        throw new IOException("Failed to bind server socket to any port [localBind=" + args.localBind() + ", portRange=" + args.port() + ".." + (args.port() + 10) + ']', ex);
    }

    @Override
    public void stop() throws Exception {
        this.th.interrupt();
        this.th.join();
    }

    @Override
    public String usage() {
        return BenchmarkUtils.usage(this.args);
    }
}

