/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.startup.servlet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;

public class ServletContextListenerStartup
implements ServletContextListener {
    public static final String IGNITE_CFG_FILE_PATH_PARAM = "IgniteConfigurationFilePath";
    private final Collection<String> igniteInstanceNames = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void contextInitialized(ServletContextEvent evt) {
        Collection<Object> cfgs;
        Object cfgUrl;
        ServletContext ctx = evt.getServletContext();
        String cfgFile = ctx.getInitParameter(IGNITE_CFG_FILE_PATH_PARAM);
        GridSpringResourceContext rsrcCtx = null;
        if (cfgFile != null) {
            IgniteBiTuple igniteBiTuple;
            cfgUrl = null;
            try {
                cfgUrl = evt.getServletContext().getResource("/META-INF/" + cfgFile);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (cfgUrl == null) {
                cfgUrl = U.resolveIgniteUrl((String)cfgFile);
            }
            if (cfgUrl == null) {
                throw new IgniteException("Failed to find Spring configuration file (path provided should be either absolute, relative to IGNITE_HOME, or relative to META-INF folder): " + cfgFile);
            }
            try {
                igniteBiTuple = IgnitionEx.loadConfigurations((URL)cfgUrl);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to load Ignite configuration.", (Throwable)e);
            }
            cfgs = (Collection)igniteBiTuple.get1();
            rsrcCtx = (GridSpringResourceContext)igniteBiTuple.get2();
            if (cfgs.isEmpty()) {
                throw new IgniteException("Can't find grid factory configuration in: " + (URL)cfgUrl);
            }
        } else {
            cfgs = Collections.singleton(new IgniteConfiguration());
        }
        try {
            assert (!cfgs.isEmpty());
            cfgUrl = cfgs.iterator();
            while (cfgUrl.hasNext()) {
                Ignite ignite;
                IgniteConfiguration igniteConfiguration = (IgniteConfiguration)cfgUrl.next();
                assert (igniteConfiguration != null);
                Class<ServletContextListenerStartup> clazz = ServletContextListenerStartup.class;
                // MONITORENTER : org.apache.ignite.startup.servlet.ServletContextListenerStartup.class
                try {
                    ignite = G.ignite((String)igniteConfiguration.getIgniteInstanceName());
                }
                catch (IgniteIllegalStateException ignored) {
                    ignite = IgnitionEx.start((IgniteConfiguration)new IgniteConfiguration(igniteConfiguration), (GridSpringResourceContext)rsrcCtx);
                }
                if (ignite == null) continue;
                this.igniteInstanceNames.add(ignite.name());
            }
            return;
        }
        catch (IgniteCheckedException e) {
            Iterator<String> iterator = this.igniteInstanceNames.iterator();
            while (iterator.hasNext()) {
                String name = iterator.next();
                G.stop((String)name, (boolean)true);
            }
            throw new IgniteException("Failed to start Ignite.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent evt) {
        for (String name : this.igniteInstanceNames) {
            G.stop((String)name, (boolean)true);
        }
    }

    public String toString() {
        return S.toString(ServletContextListenerStartup.class, (Object)this);
    }
}

