/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.List;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlInternalOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.calcite.sql.fun.SqlDatetimeSubtractionOperator;
import org.apache.calcite.sql.fun.SqlInOperator;
import org.apache.calcite.sql.fun.SqlLiteralAggFunction;
import org.apache.calcite.sql.fun.SqlRollupOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.util.Litmus;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlInternalOperators {
    public static final SqlRowOperator ANONYMOUS_ROW = new SqlRowOperator("$ANONYMOUS_ROW"){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            List<@Nullable SqlNode> operandList = call.getOperandList();
            writer.list(SqlWriter.FrameTypeEnum.PARENTHESES, SqlWriter.COMMA, SqlNodeList.of(call.getParserPosition(), operandList));
        }
    };
    public static final SqlRowOperator ANONYMOUS_ROW_NO_PARENTHESES = new SqlRowOperator("$ANONYMOUS_ROW_NO_PARENTHESES"){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL);
            for (SqlNode operand : call.getOperandList()) {
                writer.sep(",");
                operand.unparse(writer, leftPrec, rightPrec);
            }
            writer.endList(frame);
        }
    };
    public static final SqlInternalOperator THROW_UNLESS = new SqlInternalOperator("$THROW_UNLESS", SqlKind.OTHER);
    public static final SqlInOperator DRUID_IN = new SqlInOperator(SqlKind.DRUID_IN);
    public static final SqlInOperator DRUID_NOT_IN = new SqlInOperator(SqlKind.DRUID_NOT_IN);
    public static final SqlBetweenOperator DRUID_BETWEEN = new SqlBetweenOperator(SqlBetweenOperator.Flag.SYMMETRIC, false){

        @Override
        public SqlKind getKind() {
            return SqlKind.DRUID_BETWEEN;
        }

        @Override
        public boolean validRexOperands(int count, Litmus litmus) {
            return litmus.succeed();
        }
    };
    public static final SqlOperator SEPARATOR = new SqlInternalOperator("SEPARATOR", SqlKind.SEPARATOR, 20, false, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, (SqlOperandTypeChecker)OperandTypes.ANY);
    public static final SqlInternalOperator GROUP_BY_DISTINCT = new SqlRollupOperator("GROUP BY DISTINCT", SqlKind.GROUP_BY_DISTINCT);
    public static final SqlOperator FETCH = SqlBasicOperator.create("FETCH").withPrecedence(SqlStdOperatorTable.UNION.getLeftPrec() - 2, true);
    public static final SqlDatetimeSubtractionOperator MINUS_DATE2 = new SqlDatetimeSubtractionOperator("MINUS_DATE2", ReturnTypes.ARG0_NULLABLE);
    public static final SqlOperator OFFSET = SqlBasicOperator.create("OFFSET").withPrecedence(SqlStdOperatorTable.UNION.getLeftPrec() - 2, true);
    public static final SqlAggFunction LITERAL_AGG = SqlLiteralAggFunction.INSTANCE;

    private SqlInternalOperators() {
    }

    private static class SqlBasicOperator
    extends SqlOperator {
        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        private SqlBasicOperator(String name, int leftPrecedence, int rightPrecedence) {
            super(name, SqlKind.OTHER, leftPrecedence, rightPrecedence, ReturnTypes.BOOLEAN, InferTypes.RETURN_TYPE, (SqlOperandTypeChecker)OperandTypes.ANY);
        }

        static SqlBasicOperator create(String name) {
            return new SqlBasicOperator(name, 0, 0);
        }

        SqlBasicOperator withPrecedence(int prec, boolean leftAssoc) {
            return new SqlBasicOperator(this.getName(), SqlBasicOperator.leftPrec(prec, leftAssoc), SqlBasicOperator.rightPrec(prec, leftAssoc));
        }
    }
}

