/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Locale;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryArray;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.jackson.IgniteBinaryObjectJsonDeserializer;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;

public class IgniteObjectMapper
extends ObjectMapper {
    public static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private static final JsonSerializer<Object> NULL_KEY_SERIALIZER = new JsonSerializer<Object>(){

        public void serialize(Object val, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeFieldName("");
        }
    };
    private static final JsonSerializer<Object> NULL_VALUE_SERIALIZER = new JsonSerializer<Object>(){

        public void serialize(Object val, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeNull();
        }
    };
    private static final JsonSerializer<Throwable> THROWABLE_SERIALIZER = new JsonSerializer<Throwable>(){

        private void writeException(Throwable e, JsonGenerator gen) throws IOException {
            if (e instanceof VisorExceptionWrapper) {
                VisorExceptionWrapper wrapper = (VisorExceptionWrapper)e;
                gen.writeStringField("className", wrapper.getClassName());
            } else {
                gen.writeStringField("className", e.getClass().getName());
            }
            if (e.getMessage() != null) {
                gen.writeStringField("message", e.getMessage());
            }
            if (e instanceof SQLException) {
                SQLException sqlE = (SQLException)e;
                gen.writeNumberField("errorCode", sqlE.getErrorCode());
                gen.writeStringField("SQLState", sqlE.getSQLState());
            }
        }

        public void serialize(Throwable e, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            this.writeException(e, gen);
            if (e.getCause() != null) {
                gen.writeObjectField("cause", (Object)e.getCause());
            }
            if (!F.isEmpty((Object[])e.getSuppressed())) {
                gen.writeArrayFieldStart("suppressed");
                for (Throwable sup : e.getSuppressed()) {
                    gen.writeObject((Object)sup);
                }
                gen.writeEndArray();
            }
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<IgniteUuid> IGNITE_UUID_SERIALIZER = new JsonSerializer<IgniteUuid>(){

        public void serialize(IgniteUuid uid, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeString(uid.toString());
        }
    };
    private static final JsonSerializer<IgniteBiTuple> IGNITE_TUPLE_SERIALIZER = new JsonSerializer<IgniteBiTuple>(){

        public void serialize(IgniteBiTuple t, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("key", t.getKey());
            gen.writeObjectField("value", t.getValue());
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<GridCacheSqlMetadata> IGNITE_SQL_METADATA_SERIALIZER = new JsonSerializer<GridCacheSqlMetadata>(){

        public void serialize(GridCacheSqlMetadata m, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("cacheName", m.cacheName());
            gen.writeObjectField("types", (Object)m.types());
            gen.writeObjectField("keyClasses", (Object)m.keyClasses());
            gen.writeObjectField("valClasses", (Object)m.valClasses());
            gen.writeObjectField("fields", (Object)m.fields());
            gen.writeObjectField("indexes", (Object)m.indexes());
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<GridCacheSqlIndexMetadata> IGNITE_SQL_INDEX_METADATA_SERIALIZER = new JsonSerializer<GridCacheSqlIndexMetadata>(){

        public void serialize(GridCacheSqlIndexMetadata idx, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("name", idx.name());
            gen.writeObjectField("fields", (Object)idx.fields());
            gen.writeObjectField("descendings", (Object)idx.descendings());
            gen.writeBooleanField("unique", idx.unique());
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<BinaryObjectImpl> IGNITE_BINARY_OBJECT_SERIALIZER = new JsonSerializer<BinaryObjectImpl>(){

        public void serialize(BinaryObjectImpl bin, JsonGenerator gen, SerializerProvider ser) throws IOException {
            try {
                BinaryType meta = bin.rawType();
                if (meta != null && !F.isEmpty((Collection)meta.fieldNames())) {
                    gen.writeStartObject();
                    for (String name : meta.fieldNames()) {
                        BinaryObjectImpl ref;
                        Object val = bin.field(name);
                        if (val instanceof BinaryObjectImpl && (ref = (BinaryObjectImpl)val).hasCircularReferences()) {
                            throw ser.mappingException("Failed convert to JSON object for circular references", new Object[0]);
                        }
                        if (val instanceof BinaryEnumObjectImpl) {
                            gen.writeObjectField(name, (Object)((BinaryObject)val).enumName());
                            continue;
                        }
                        gen.writeObjectField(name, val);
                    }
                    gen.writeEndObject();
                } else {
                    Object obj = bin.deserialize();
                    gen.writeObject(obj);
                }
            }
            catch (BinaryObjectException ignore) {
                gen.writeNull();
            }
        }
    };
    private static final JsonSerializer<BinaryArray> IGNITE_BINARY_ARRAY_SERIALIZER = new JsonSerializer<BinaryArray>(){

        public void serialize(BinaryArray val, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (Object o : val.array()) {
                gen.writeObject(o);
            }
            gen.writeEndArray();
        }
    };
    private static final JsonSerializer<Timestamp> IGNITE_TIMESTAMP_SERIALIZER = new JsonSerializer<Timestamp>(){

        public void serialize(Timestamp timestamp, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(timestamp.toString());
        }
    };
    private static final JsonSerializer<Date> IGNITE_SQLDATE_SERIALIZER = new JsonSerializer<Date>(){

        public void serialize(Date date, JsonGenerator gen, SerializerProvider prov) throws IOException {
            gen.writeString(date.toString());
        }
    };
    private static final JsonDeserializer<Timestamp> IGNITE_TIMESTAMP_DESERIALIZER = new JsonDeserializer<Timestamp>(){

        public Timestamp deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JsonProcessingException {
            return Timestamp.valueOf(parser.getText());
        }
    };
    private static final JsonDeserializer<Date> IGNITE_SQLDATE_DESERIALIZER = new JsonDeserializer<Date>(){

        public Date deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JsonProcessingException {
            return Date.valueOf(parser.getText());
        }
    };

    public IgniteObjectMapper() {
        this(null);
    }

    public IgniteObjectMapper(GridKernalContext ctx) {
        super(null, (DefaultSerializerProvider)new CustomSerializerProvider(), null);
        this.setDateFormat(DATE_FORMAT);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Throwable.class, THROWABLE_SERIALIZER);
        module.addSerializer(IgniteBiTuple.class, IGNITE_TUPLE_SERIALIZER);
        module.addSerializer(IgniteUuid.class, IGNITE_UUID_SERIALIZER);
        module.addSerializer(GridCacheSqlMetadata.class, IGNITE_SQL_METADATA_SERIALIZER);
        module.addSerializer(GridCacheSqlIndexMetadata.class, IGNITE_SQL_INDEX_METADATA_SERIALIZER);
        module.addSerializer(BinaryObjectImpl.class, IGNITE_BINARY_OBJECT_SERIALIZER);
        module.addSerializer(BinaryArray.class, IGNITE_BINARY_ARRAY_SERIALIZER);
        module.addSerializer(Timestamp.class, IGNITE_TIMESTAMP_SERIALIZER);
        module.addDeserializer(Timestamp.class, IGNITE_TIMESTAMP_DESERIALIZER);
        module.addSerializer(Date.class, IGNITE_SQLDATE_SERIALIZER);
        module.addDeserializer(Date.class, IGNITE_SQLDATE_DESERIALIZER);
        if (ctx != null) {
            module.addDeserializer(BinaryObject.class, (JsonDeserializer)new IgniteBinaryObjectJsonDeserializer(ctx));
            IgnitePredicate clsFilter = ctx.marshallerContext().classNameFilter();
            if (clsFilter != null) {
                this.setDefaultTyping((TypeResolverBuilder)new RestrictedTypeResolverBuilder((IgnitePredicate<String>)clsFilter).init(JsonTypeInfo.Id.CLASS, null));
            }
        }
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.registerModule((Module)module);
    }

    private static class RestrictedTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        private final IgnitePredicate<String> clsFilter;

        public RestrictedTypeResolverBuilder(IgnitePredicate<String> clsFilter) {
            super(ObjectMapper.DefaultTyping.NON_FINAL);
            this.clsFilter = clsFilter;
        }

        public boolean useForType(JavaType type) {
            String clsName = type.getRawClass().getName();
            if (!this.clsFilter.apply((Object)clsName)) {
                throw new IgniteException("Deserialization of class " + clsName + " is disallowed.");
            }
            return false;
        }
    }

    private static class CustomSerializerProvider
    extends DefaultSerializerProvider {
        CustomSerializerProvider() {
        }

        CustomSerializerProvider(SerializerProvider src, SerializationConfig cfg, SerializerFactory f) {
            super(src, cfg, f);
        }

        public DefaultSerializerProvider createInstance(SerializationConfig cfg, SerializerFactory jsf) {
            return new CustomSerializerProvider((SerializerProvider)this, cfg, jsf);
        }

        public JsonSerializer<Object> findNullKeySerializer(JavaType serializationType, BeanProperty prop) {
            return NULL_KEY_SERIALIZER;
        }

        public JsonSerializer<Object> findNullValueSerializer(BeanProperty prop) {
            return NULL_VALUE_SERIALIZER;
        }
    }
}

