/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.DirectBufferCleaner;

public class ReflectiveDirectBufferCleaner
implements DirectBufferCleaner {
    private final Method cleanerMtd;
    private final Method cleanMtd;

    public ReflectiveDirectBufferCleaner() {
        try {
            this.cleanerMtd = Class.forName("sun.nio.ch.DirectBuffer").getMethod("cleaner", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("No sun.nio.ch.DirectBuffer.cleaner() method found", e);
        }
        try {
            this.cleanMtd = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("No sun.misc.Cleaner.clean() method found", e);
        }
    }

    @Override
    public void clean(ByteBuffer buf) {
        try {
            this.cleanMtd.invoke(this.cleanerMtd.invoke((Object)buf, new Object[0]), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke direct buffer cleaner", e);
        }
    }
}

