/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionAllNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionCompositeNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionCompositeNodeOperator;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionConstantNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionGroupNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNoneNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionParameterNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionParameterType;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionSingleNode;

public class PartitionResultMarshaler {
    static final byte COMPOSITE_NODE = 1;
    static final byte CONST_NODE = 2;
    static final byte GROUP_NODE = 3;
    static final byte PARAM_NODE = 4;

    public static void marshal(BinaryWriterExImpl writer, PartitionResult partRes) throws BinaryObjectException {
        PartitionResultMarshaler.writeNode(writer, partRes.tree());
        writer.writeString(partRes.cacheName());
        writer.writeInt(partRes.partitionsCount());
        writer.writeLong(partRes.topologyVersion().topologyVersion());
        writer.writeInt(partRes.topologyVersion().minorTopologyVersion());
    }

    public static PartitionResult unmarshal(BinaryReaderExImpl reader) throws BinaryObjectException {
        PartitionNode tree = PartitionResultMarshaler.readNode(reader);
        String cacheName = reader.readString();
        int partsCnt = reader.readInt();
        AffinityTopologyVersion topVer = new AffinityTopologyVersion(reader.readLong(), reader.readInt());
        return new PartitionResult(tree, topVer, cacheName, partsCnt);
    }

    private static PartitionNode readNode(BinaryReaderExImpl reader) throws BinaryObjectException {
        byte nodeType = reader.readByte();
        switch (nodeType) {
            case 1: {
                return PartitionResultMarshaler.readCompositeNode(reader);
            }
            case 2: {
                return PartitionResultMarshaler.readConstantNode(reader);
            }
            case 3: {
                return PartitionResultMarshaler.readGroupNode(reader);
            }
            case 4: {
                return PartitionResultMarshaler.readParameterNode(reader);
            }
        }
        throw new IllegalArgumentException("Partition node type " + nodeType + " not supported.");
    }

    private static void writeNode(BinaryWriterExImpl writer, PartitionNode node) throws BinaryObjectException {
        assert (!(node instanceof PartitionAllNode));
        assert (!(node instanceof PartitionNoneNode));
        if (node instanceof PartitionCompositeNode) {
            PartitionResultMarshaler.writeCompositeNode(writer, (PartitionCompositeNode)node);
        } else if (node instanceof PartitionConstantNode) {
            PartitionResultMarshaler.writeConstantNode(writer, (PartitionConstantNode)node);
        } else if (node instanceof PartitionGroupNode) {
            PartitionResultMarshaler.writeGroupNode(writer, (PartitionGroupNode)node);
        } else if (node instanceof PartitionParameterNode) {
            PartitionResultMarshaler.writeParameterNode(writer, (PartitionParameterNode)node);
        } else {
            throw new IllegalArgumentException("Partition node type " + node.getClass() + " not supported.");
        }
    }

    private static PartitionConstantNode readConstantNode(BinaryReaderExImpl reader) throws BinaryObjectException {
        int part = reader.readInt();
        return new PartitionConstantNode(null, part);
    }

    private static void writeConstantNode(BinaryWriterExImpl writer, PartitionConstantNode node) throws BinaryObjectException {
        writer.writeByte((byte)2);
        writer.writeInt(node.value());
    }

    private static PartitionCompositeNode readCompositeNode(BinaryReaderExImpl reader) throws BinaryObjectException {
        PartitionCompositeNodeOperator op = PartitionCompositeNodeOperator.fromOrdinal(reader.readInt());
        PartitionNode left = PartitionResultMarshaler.readNode(reader);
        PartitionNode right = PartitionResultMarshaler.readNode(reader);
        return new PartitionCompositeNode(left, right, op);
    }

    private static void writeCompositeNode(BinaryWriterExImpl writer, PartitionCompositeNode node) throws BinaryObjectException {
        writer.writeByte((byte)1);
        writer.writeInt(node.operator().ordinal());
        PartitionResultMarshaler.writeNode(writer, node.left());
        PartitionResultMarshaler.writeNode(writer, node.right());
    }

    private static PartitionGroupNode readGroupNode(BinaryReaderExImpl reader) throws BinaryObjectException {
        int siblingsCnt = reader.readInt();
        HashSet<PartitionSingleNode> siblings = new HashSet<PartitionSingleNode>(siblingsCnt);
        block4: for (int i = 0; i < siblingsCnt; ++i) {
            byte nodeType = reader.readByte();
            switch (nodeType) {
                case 2: {
                    siblings.add(PartitionResultMarshaler.readConstantNode(reader));
                    continue block4;
                }
                case 4: {
                    siblings.add(PartitionResultMarshaler.readParameterNode(reader));
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Partition node type " + nodeType + " is not valid signle node.");
                }
            }
        }
        return new PartitionGroupNode(siblings);
    }

    private static void writeGroupNode(BinaryWriterExImpl writer, PartitionGroupNode node) throws BinaryObjectException {
        writer.writeByte((byte)3);
        Set<PartitionSingleNode> siblings = node.siblings();
        assert (siblings != null);
        writer.writeInt(siblings.size());
        for (PartitionSingleNode singleNode : siblings) {
            if (singleNode instanceof PartitionConstantNode) {
                PartitionResultMarshaler.writeConstantNode(writer, (PartitionConstantNode)singleNode);
                continue;
            }
            if (singleNode instanceof PartitionParameterNode) {
                PartitionResultMarshaler.writeParameterNode(writer, (PartitionParameterNode)singleNode);
                continue;
            }
            throw new IllegalArgumentException("Partition node type " + singleNode.getClass() + " not supported.");
        }
    }

    private static PartitionParameterNode readParameterNode(BinaryReaderExImpl reader) throws BinaryObjectException {
        int idx = reader.readInt();
        PartitionParameterType clientType = PartitionParameterType.fromOrdinal(reader.readInt());
        return new PartitionParameterNode(null, null, idx, -1, clientType);
    }

    private static void writeParameterNode(BinaryWriterExImpl writer, PartitionParameterNode node) throws BinaryObjectException {
        writer.writeByte((byte)4);
        writer.writeInt(node.value());
        writer.writeInt(node.clientType().ordinal());
    }
}

