/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.cluster;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestChangeStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridChangeStateCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> commands = U.sealList(GridRestCommand.CLUSTER_ACTIVATE, GridRestCommand.CLUSTER_DEACTIVATE, GridRestCommand.CLUSTER_CURRENT_STATE, GridRestCommand.CLUSTER_ACTIVE, GridRestCommand.CLUSTER_INACTIVE);

    public GridChangeStateCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return commands;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest restRest) throws IgniteCheckedException {
        GridRestChangeStateRequest req = (GridRestChangeStateRequest)restRest;
        switch (req.command()) {
            case CLUSTER_CURRENT_STATE: {
                Boolean curState = this.ctx.state().publicApiActiveState(false);
                return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(curState));
            }
            case CLUSTER_ACTIVE: 
            case CLUSTER_INACTIVE: {
                this.log.warning(req.command().key() + " is deprecated. Use newer commands.");
            }
        }
        this.ctx.state().changeGlobalState(req.active() ? ClusterState.ACTIVE : ClusterState.INACTIVE, req.forceDeactivation(), this.ctx.cluster().get().forServers().nodes(), false).get();
        return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(req.command().key() + " started"));
    }
}

