/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryRowDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.jetbrains.annotations.Nullable;

public class GridQueryRowDescriptorImpl
implements GridQueryRowDescriptor {
    public static final int COL_NOT_EXISTS = -1;
    private final GridCacheContextInfo<?, ?> cacheInfo;
    private final GridQueryTypeDescriptor type;
    private volatile String[] fields;
    private volatile GridQueryProperty[] props;
    private volatile Set<String> rowKeyColumnNames;
    private volatile int keyAliasColId;
    private volatile int valAliasColId;

    public GridQueryRowDescriptorImpl(GridCacheContextInfo<?, ?> cacheInfo, GridQueryTypeDescriptor type) {
        assert (type != null);
        this.cacheInfo = cacheInfo;
        this.type = type;
        this.onMetadataUpdated();
    }

    @Override
    public final void onMetadataUpdated() {
        this.fields = this.type.fields().keySet().toArray(new String[this.type.fields().size()]);
        this.props = new GridQueryProperty[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            GridQueryProperty p = this.type.property(this.fields[i]);
            assert (p != null) : this.fields[i];
            this.props[i] = p;
        }
        List<String> fieldsList = Arrays.asList(this.fields);
        this.keyAliasColId = this.type.keyFieldName() != null ? 2 + fieldsList.indexOf(this.type.keyFieldAlias()) : -1;
        this.valAliasColId = this.type.valueFieldName() != null ? 2 + fieldsList.indexOf(this.type.valueFieldAlias()) : -1;
        this.rowKeyColumnNames = Arrays.stream(this.props).filter(GridQueryProperty::key).map(GridQueryProperty::name).collect(Collectors.toSet());
    }

    @Override
    public GridQueryTypeDescriptor type() {
        return this.type;
    }

    @Override
    @Nullable
    public GridCacheContext<?, ?> context() {
        return this.cacheInfo.cacheContext();
    }

    @Override
    public int fieldsCount() {
        return this.fields.length;
    }

    @Override
    public Object getFieldValue(Object key, Object val, int fieldIdx) {
        try {
            return this.props[fieldIdx].value(key, val);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void setFieldValue(Object key, Object val, Object fieldVal, int fieldIdx) {
        try {
            this.props[fieldIdx].setValue(key, val, fieldVal);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public boolean isFieldKeyProperty(int fieldIdx) {
        return this.props[fieldIdx].key();
    }

    @Override
    public boolean isKeyColumn(int colId) {
        assert (colId >= 0);
        return colId == 0 || colId == this.keyAliasColId;
    }

    @Override
    public boolean isValueColumn(int colId) {
        assert (colId >= 0);
        return colId == 1 || colId == this.valAliasColId;
    }

    @Override
    public int getAlternativeColumnId(int colId) {
        if (this.keyAliasColId > 0) {
            if (colId == 0) {
                return this.keyAliasColId;
            }
            if (colId == this.keyAliasColId) {
                return 0;
            }
        }
        if (this.valAliasColId > 0) {
            if (colId == 1) {
                return this.valAliasColId;
            }
            if (colId == this.valAliasColId) {
                return 1;
            }
        }
        return colId;
    }

    @Override
    public Set<String> getRowKeyColumnNames() {
        return new HashSet<String>(this.rowKeyColumnNames);
    }
}

