/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller.optimized;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.marshaller.optimized.OptimizedClassDescriptor;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshallerIdMapper;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshallerUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.io.GridDataInput;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.MarshallerContext;

class OptimizedObjectInputStream
extends ObjectInputStream {
    private static final Object DUMMY = new Object();
    private final HandleTable handles = new HandleTable(10);
    private MarshallerContext ctx;
    private OptimizedMarshallerIdMapper mapper;
    private ClassLoader clsLdr;
    private GridDataInput in;
    private Object curObj;
    private OptimizedClassDescriptor.ClassFields curFields;
    private Class<?> curCls;
    private ConcurrentMap<Class, OptimizedClassDescriptor> clsMap;
    private boolean useCache;

    OptimizedObjectInputStream(GridDataInput in) throws IOException {
        this.in = in;
        this.useCache = true;
    }

    void context(ConcurrentMap<Class, OptimizedClassDescriptor> clsMap, MarshallerContext ctx, OptimizedMarshallerIdMapper mapper, ClassLoader clsLdr, boolean useCache) {
        this.clsMap = clsMap;
        this.ctx = ctx;
        this.mapper = mapper;
        this.clsLdr = clsLdr;
        this.useCache = useCache;
    }

    public GridDataInput in() {
        return this.in;
    }

    public void in(GridDataInput in) {
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        this.reset();
        this.ctx = null;
        this.clsLdr = null;
        this.clsMap = null;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.handles.clear();
        this.curObj = null;
        this.curFields = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObjectOverride() throws ClassNotFoundException, IOException {
        Object oldObj = this.curObj;
        OptimizedClassDescriptor.ClassFields oldFields = this.curFields;
        try {
            Object object = this.readObject0();
            return object;
        }
        finally {
            this.curObj = oldObj;
            this.curFields = oldFields;
        }
    }

    private Object readObject0() throws ClassNotFoundException, IOException {
        this.curObj = null;
        this.curFields = null;
        byte ref = this.in.readByte();
        switch (ref) {
            case 0: {
                return null;
            }
            case -1: {
                return this.handles.lookup(this.readInt());
            }
            case -2: {
                try {
                    return this.ctx.jdkMarshaller().unmarshal(this, this.clsLdr);
                }
                catch (IgniteCheckedException e) {
                    IOException ioEx = e.getCause(IOException.class);
                    if (ioEx != null) {
                        throw ioEx;
                    }
                    throw new IOException("Failed to deserialize object with JDK marshaller.", e);
                }
            }
            case 1: {
                return this.readByte();
            }
            case 2: {
                return this.readShort();
            }
            case 3: {
                return this.readInt();
            }
            case 4: {
                return this.readLong();
            }
            case 5: {
                return Float.valueOf(this.readFloat());
            }
            case 6: {
                return this.readDouble();
            }
            case 7: {
                return Character.valueOf(this.readChar());
            }
            case 8: {
                return this.readBoolean();
            }
            case 9: {
                return this.readByteArray();
            }
            case 10: {
                return this.readShortArray();
            }
            case 11: {
                return this.readIntArray();
            }
            case 12: {
                return this.readLongArray();
            }
            case 13: {
                return this.readFloatArray();
            }
            case 14: {
                return this.readDoubleArray();
            }
            case 15: {
                return this.readCharArray();
            }
            case 16: {
                return this.readBooleanArray();
            }
            case 17: {
                return this.readArray(this.readClass());
            }
            case 18: {
                return this.readString();
            }
            case 19: {
                return this.readUuid();
            }
            case 20: {
                return this.readProperties();
            }
            case 21: {
                return this.readArrayList();
            }
            case 22: {
                return this.readHashMap(false);
            }
            case 23: {
                return this.readHashSet(OptimizedMarshallerUtils.HASH_SET_MAP_OFF);
            }
            case 24: {
                return this.readLinkedList();
            }
            case 25: {
                return this.readLinkedHashMap(false);
            }
            case 26: {
                return this.readLinkedHashSet(OptimizedMarshallerUtils.HASH_SET_MAP_OFF);
            }
            case 27: {
                return this.readDate();
            }
            case 28: {
                return this.readClass();
            }
            case 29: {
                Class[] intfs = new Class[this.readInt()];
                for (int i = 0; i < intfs.length; ++i) {
                    intfs[i] = this.readClass();
                }
                InvocationHandler ih = (InvocationHandler)this.readObject();
                return Proxy.newProxyInstance(this.clsLdr != null ? this.clsLdr : U.gridClassLoader(), intfs, ih);
            }
            case 100: 
            case 101: 
            case 102: {
                int typeId = this.readInt();
                OptimizedClassDescriptor desc = typeId == 0 ? OptimizedMarshallerUtils.classDescriptor(this.clsMap, U.forName(this.readUTF(), this.clsLdr, this.ctx.classNameFilter()), this.useCache, this.ctx, this.mapper) : OptimizedMarshallerUtils.classDescriptor(this.clsMap, typeId, this.clsLdr, this.useCache, this.ctx, this.mapper);
                this.curCls = desc.describedClass();
                try {
                    return desc.read(this);
                }
                catch (IOException e) {
                    throw new IOException("Failed to deserialize object [typeName=" + desc.describedClass().getName() + "]", e);
                }
            }
        }
        SB msg = new SB("Unexpected error occurred during unmarshalling");
        if (this.curCls != null) {
            msg.a(" of an instance of the class: ").a(this.curCls.getName());
        }
        msg.a(". Check that all nodes are running the same version of Ignite and that all nodes have GridOptimizedMarshaller configured with identical optimized classes lists, if any (see setClassNames and setClassNamesPath methods). If your serialized classes implement java.io.Externalizable interface, verify that serialization logic is correct.");
        throw new IOException(msg.toString());
    }

    private Class<?> readClass() throws ClassNotFoundException, IOException {
        int compTypeId = this.readInt();
        return compTypeId == 0 ? U.forName(this.readUTF(), this.clsLdr, null, this.useCache) : OptimizedMarshallerUtils.classDescriptor(this.clsMap, compTypeId, this.clsLdr, this.useCache, this.ctx, this.mapper).describedClass();
    }

    <T> T[] readArray(Class<T> compType) throws ClassNotFoundException, IOException {
        int len = this.in.readInt();
        Object[] arr = (Object[])Array.newInstance(compType, len);
        this.handles.assign(arr);
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readObject();
        }
        return arr;
    }

    UUID readUuid() throws IOException {
        UUID uuid = new UUID(this.readLong(), this.readLong());
        this.handles.assign(uuid);
        return uuid;
    }

    Properties readProperties() throws ClassNotFoundException, IOException {
        Properties dflts = this.readBoolean() ? null : (Properties)this.readObject();
        Properties props = new Properties(dflts);
        int size = this.in.readInt();
        for (int i = 0; i < size; ++i) {
            props.setProperty(this.readUTF(), this.readUTF());
        }
        this.handles.assign(props);
        return props;
    }

    void readFields(Object obj, OptimizedClassDescriptor.ClassFields fieldOffs) throws ClassNotFoundException, IOException {
        for (int i = 0; i < fieldOffs.size(); ++i) {
            OptimizedClassDescriptor.FieldInfo t = fieldOffs.get(i);
            try {
                switch (t.type()) {
                    case BYTE: {
                        byte resByte = this.readByte();
                        if (t.field() == null) break;
                        OptimizedMarshallerUtils.setByte(obj, t.offset(), resByte);
                        break;
                    }
                    case SHORT: {
                        short resShort = this.readShort();
                        if (t.field() == null) break;
                        OptimizedMarshallerUtils.setShort(obj, t.offset(), resShort);
                        break;
                    }
                    case INT: {
                        int resInt = this.readInt();
                        if (t.field() == null) break;
                        OptimizedMarshallerUtils.setInt(obj, t.offset(), resInt);
                        break;
                    }
                    case LONG: {
                        long resLong = this.readLong();
                        if (t.field() == null) break;
                        OptimizedMarshallerUtils.setLong(obj, t.offset(), resLong);
                        break;
                    }
                    case FLOAT: {
                        float resFloat = this.readFloat();
                        if (t.field() == null) break;
                        OptimizedMarshallerUtils.setFloat(obj, t.offset(), resFloat);
                        break;
                    }
                    case DOUBLE: {
                        double resDouble = this.readDouble();
                        if (t.field() == null) break;
                        OptimizedMarshallerUtils.setDouble(obj, t.offset(), resDouble);
                        break;
                    }
                    case CHAR: {
                        char resChar = this.readChar();
                        if (t.field() == null) break;
                        OptimizedMarshallerUtils.setChar(obj, t.offset(), resChar);
                        break;
                    }
                    case BOOLEAN: {
                        boolean resBoolean = this.readBoolean();
                        if (t.field() == null) break;
                        OptimizedMarshallerUtils.setBoolean(obj, t.offset(), resBoolean);
                        break;
                    }
                    case OTHER: {
                        Object resObj = this.readObject();
                        if (t.field() == null) break;
                        OptimizedMarshallerUtils.setObject(obj, t.offset(), resObj);
                    }
                }
                continue;
            }
            catch (IOException e) {
                throw new IOException("Failed to deserialize field [name=" + t.name() + "]", e);
            }
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        return U.forName(desc.getName(), this.clsLdr, this.ctx.classNameFilter());
    }

    Object readExternalizable(Constructor<?> constructor, Method readResolveMtd) throws ClassNotFoundException, IOException {
        Object obj;
        try {
            obj = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(e);
        }
        int handle = this.handles.assign(obj);
        Externalizable extObj = (Externalizable)obj;
        extObj.readExternal(this);
        if (readResolveMtd != null) {
            try {
                obj = readResolveMtd.invoke(obj, new Object[0]);
                this.handles.set(handle, obj);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        return obj;
    }

    Object readSerializable(Class<?> cls, List<Method> mtds, Method readResolveMtd, OptimizedClassDescriptor.Fields fields) throws ClassNotFoundException, IOException {
        Object obj;
        try {
            obj = GridUnsafe.allocateInstance(cls);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        int handle = this.handles.assign(obj);
        for (int i = 0; i < mtds.size(); ++i) {
            Method mtd = mtds.get(i);
            if (mtd != null) {
                this.curObj = obj;
                this.curFields = fields.fields(i);
                try {
                    mtd.invoke(obj, this);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IOException(e);
                }
            }
            this.readFields(obj, fields.fields(i));
        }
        if (readResolveMtd != null) {
            try {
                obj = readResolveMtd.invoke(obj, new Object[0]);
                this.handles.set(handle, obj);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        return obj;
    }

    ArrayList<?> readArrayList() throws ClassNotFoundException, IOException {
        int size = this.readInt();
        ArrayList<Object> list = new ArrayList<Object>(size);
        this.handles.assign(list);
        for (int i = 0; i < size; ++i) {
            list.add(this.readObject());
        }
        return list;
    }

    HashMap<?, ?> readHashMap(boolean set) throws ClassNotFoundException, IOException {
        int size = this.readInt();
        float loadFactor = this.readFloat();
        HashMap<Object, Object> map = new HashMap<Object, Object>(size, loadFactor);
        if (!set) {
            this.handles.assign(map);
        }
        for (int i = 0; i < size; ++i) {
            Object key = this.readObject();
            Object val = !set ? this.readObject() : DUMMY;
            map.put(key, val);
        }
        return map;
    }

    HashSet<?> readHashSet(long mapFieldOff) throws ClassNotFoundException, IOException {
        try {
            HashSet set = (HashSet)GridUnsafe.allocateInstance(HashSet.class);
            this.handles.assign(set);
            OptimizedMarshallerUtils.setObject(set, mapFieldOff, this.readHashMap(true));
            return set;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
    }

    LinkedList<?> readLinkedList() throws ClassNotFoundException, IOException {
        int size = this.readInt();
        LinkedList<Object> list = new LinkedList<Object>();
        this.handles.assign(list);
        for (int i = 0; i < size; ++i) {
            list.add(this.readObject());
        }
        return list;
    }

    LinkedHashMap<?, ?> readLinkedHashMap(boolean set) throws ClassNotFoundException, IOException {
        int size = this.readInt();
        float loadFactor = this.readFloat();
        boolean accessOrder = this.readBoolean();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(size, loadFactor, accessOrder);
        if (!set) {
            this.handles.assign(map);
        }
        for (int i = 0; i < size; ++i) {
            Object key = this.readObject();
            Object val = !set ? this.readObject() : DUMMY;
            map.put(key, val);
        }
        return map;
    }

    LinkedHashSet<?> readLinkedHashSet(long mapFieldOff) throws ClassNotFoundException, IOException {
        try {
            LinkedHashSet set = (LinkedHashSet)GridUnsafe.allocateInstance(LinkedHashSet.class);
            this.handles.assign(set);
            OptimizedMarshallerUtils.setObject(set, mapFieldOff, this.readLinkedHashMap(true));
            return set;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
    }

    Date readDate() throws ClassNotFoundException, IOException {
        Date date = new Date(this.readLong());
        this.handles.assign(date);
        return date;
    }

    byte[] readByteArray() throws IOException {
        byte[] arr = this.in.readByteArray();
        this.handles.assign(arr);
        return arr;
    }

    short[] readShortArray() throws IOException {
        short[] arr = this.in.readShortArray();
        this.handles.assign(arr);
        return arr;
    }

    int[] readIntArray() throws IOException {
        int[] arr = this.in.readIntArray();
        this.handles.assign(arr);
        return arr;
    }

    long[] readLongArray() throws IOException {
        long[] arr = this.in.readLongArray();
        this.handles.assign(arr);
        return arr;
    }

    float[] readFloatArray() throws IOException {
        float[] arr = this.in.readFloatArray();
        this.handles.assign(arr);
        return arr;
    }

    double[] readDoubleArray() throws IOException {
        double[] arr = this.in.readDoubleArray();
        this.handles.assign(arr);
        return arr;
    }

    char[] readCharArray() throws IOException {
        char[] arr = this.in.readCharArray();
        this.handles.assign(arr);
        return arr;
    }

    boolean[] readBooleanArray() throws IOException {
        boolean[] arr = this.in.readBooleanArray();
        this.handles.assign(arr);
        return arr;
    }

    public String readString() throws IOException {
        String str = this.in.readUTF();
        this.handles.assign(str);
        return str;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    @Override
    public void defaultReadObject() throws IOException, ClassNotFoundException {
        if (this.curObj == null) {
            throw new NotActiveException("Not in readObject() call.");
        }
        this.readFields(this.curObj, this.curFields);
    }

    @Override
    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        if (this.curObj == null) {
            throw new NotActiveException("Not in readObject() call.");
        }
        return new GetFieldImpl(this);
    }

    @Override
    public void registerValidation(ObjectInputValidation obj, int pri) {
    }

    @Override
    public int available() throws IOException {
        return -1;
    }

    Object[] handledObjects() {
        return this.handles.entries;
    }

    private static class GetFieldImpl
    extends ObjectInputStream.GetField {
        private final OptimizedClassDescriptor.ClassFields fieldInfo;
        private final Object[] objs;

        private GetFieldImpl(OptimizedObjectInputStream in) throws IOException, ClassNotFoundException {
            this.fieldInfo = in.curFields;
            this.objs = new Object[this.fieldInfo.size()];
            for (int i = 0; i < this.fieldInfo.size(); ++i) {
                OptimizedClassDescriptor.FieldInfo t = this.fieldInfo.get(i);
                Object obj = null;
                switch (t.type()) {
                    case BYTE: {
                        obj = in.readByte();
                        break;
                    }
                    case SHORT: {
                        obj = in.readShort();
                        break;
                    }
                    case INT: {
                        obj = in.readInt();
                        break;
                    }
                    case LONG: {
                        obj = in.readLong();
                        break;
                    }
                    case FLOAT: {
                        obj = Float.valueOf(in.readFloat());
                        break;
                    }
                    case DOUBLE: {
                        obj = in.readDouble();
                        break;
                    }
                    case CHAR: {
                        obj = Character.valueOf(in.readChar());
                        break;
                    }
                    case BOOLEAN: {
                        obj = in.readBoolean();
                        break;
                    }
                    case OTHER: {
                        obj = in.readObject();
                    }
                }
                this.objs[i] = obj;
            }
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean defaulted(String name) throws IOException {
            return this.objs[this.fieldInfo.getIndex(name)] == null;
        }

        @Override
        public boolean get(String name, boolean dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public byte get(String name, byte dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public char get(String name, char dflt) throws IOException {
            return this.value(name, Character.valueOf(dflt)).charValue();
        }

        @Override
        public short get(String name, short dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public int get(String name, int dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public long get(String name, long dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public float get(String name, float dflt) throws IOException {
            return this.value(name, Float.valueOf(dflt)).floatValue();
        }

        @Override
        public double get(String name, double dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public Object get(String name, Object dflt) throws IOException {
            return this.value(name, dflt);
        }

        private <T> T value(String name, T dflt) {
            return (T)(this.objs[this.fieldInfo.getIndex(name)] != null ? this.objs[this.fieldInfo.getIndex(name)] : dflt);
        }
    }

    private static class HandleTable {
        private Object[] entries;
        private int size;

        HandleTable(int initCap) {
            this.entries = new Object[initCap];
        }

        int assign(Object obj) {
            if (this.size >= this.entries.length) {
                this.grow();
            }
            this.entries[this.size] = obj;
            return this.size++;
        }

        void set(int handle, Object obj) {
            this.entries[handle] = obj;
        }

        Object lookup(int handle) {
            return this.entries[handle];
        }

        void clear() {
            Arrays.fill(this.entries, 0, this.size, null);
            this.size = 0;
        }

        private void grow() {
            int newCap = (this.entries.length << 1) + 1;
            Object[] newEntries = new Object[newCap];
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            this.entries = newEntries;
        }
    }
}

