/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

@IgniteCodeGeneratingFail
public class IgniteIoTestMessage
implements Message {
    private static byte FLAG_PROC_FROM_NIO = 1;
    private static final long serialVersionUID = 0L;
    private long id;
    private byte flags;
    private boolean req;
    private byte[] payload;
    private long reqCreateTs;
    private long reqSndTs;
    private long reqSndTsMillis;
    private long reqRcvTs;
    private long reqRcvTsMillis;
    private long reqProcTs;
    private long resSndTs;
    private long resSndTsMillis;
    private long resRcvTs;
    private long resRcvTsMillis;
    private long resProcTs;
    @GridDirectTransient
    private UUID sndNodeId;

    public IgniteIoTestMessage() {
    }

    public IgniteIoTestMessage(long id, boolean req, byte[] payload) {
        this.id = id;
        this.req = req;
        this.payload = payload;
        this.reqCreateTs = System.nanoTime();
    }

    public boolean processFromNioThread() {
        return this.isFlag(FLAG_PROC_FROM_NIO);
    }

    public void processFromNioThread(boolean procFromNioThread) {
        this.setFlag(procFromNioThread, FLAG_PROC_FROM_NIO);
    }

    public void flags(byte flags) {
        this.flags = flags;
    }

    public byte flags() {
        return this.flags;
    }

    private void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    private boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public boolean request() {
        return this.req;
    }

    public long id() {
        return this.id;
    }

    public long requestCreateTs() {
        return this.reqCreateTs;
    }

    public long requestSendTs() {
        return this.reqSndTs;
    }

    public long requestReceiveTs() {
        return this.reqRcvTs;
    }

    public long requestProcessTs() {
        return this.reqProcTs;
    }

    public long responseSendTs() {
        return this.resSndTs;
    }

    public long responseReceiveTs() {
        return this.resRcvTs;
    }

    public long responseProcessTs() {
        return this.resProcTs;
    }

    public long requestSendTsMillis() {
        return this.reqSndTsMillis;
    }

    public long requestReceivedTsMillis() {
        return this.reqRcvTsMillis;
    }

    public long responseSendTsMillis() {
        return this.resSndTsMillis;
    }

    public long responseReceivedTsMillis() {
        return this.resRcvTsMillis;
    }

    public void onAfterRead() {
        if (this.req && this.reqRcvTs == 0L) {
            this.reqRcvTs = System.nanoTime();
            this.reqRcvTsMillis = System.currentTimeMillis();
        }
        if (!this.req && this.resRcvTs == 0L) {
            this.resRcvTs = System.nanoTime();
            this.resRcvTsMillis = System.currentTimeMillis();
        }
    }

    public void onBeforeWrite() {
        if (this.req && this.reqSndTs == 0L) {
            this.reqSndTs = System.nanoTime();
            this.reqSndTsMillis = System.currentTimeMillis();
        }
        if (!this.req && this.resSndTs == 0L) {
            this.resSndTs = System.nanoTime();
            this.resSndTsMillis = System.currentTimeMillis();
        }
    }

    public void copyDataFromRequest(IgniteIoTestMessage req) {
        this.reqCreateTs = req.reqCreateTs;
        this.reqSndTs = req.reqSndTs;
        this.reqSndTsMillis = req.reqSndTsMillis;
        this.reqRcvTs = req.reqRcvTs;
        this.reqRcvTsMillis = req.reqRcvTsMillis;
    }

    public void onRequestProcessed() {
        this.reqProcTs = System.nanoTime();
    }

    public void onResponseProcessed() {
        this.resProcTs = System.nanoTime();
    }

    public long responseProcessedTs() {
        return this.resProcTs;
    }

    public UUID senderNodeId() {
        return this.sndNodeId;
    }

    public void senderNodeId(UUID sndNodeId) {
        this.sndNodeId = sndNodeId;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        this.onBeforeWrite();
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("id", this.id)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByteArray("payload", this.payload)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeBoolean("req", this.req)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("reqCreateTs", this.reqCreateTs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("reqProcTs", this.reqProcTs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeLong("reqRcvTs", this.reqRcvTs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeLong("reqRcvTsMillis", this.reqRcvTsMillis)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeLong("reqSndTs", this.reqSndTs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeLong("reqSndTsMillis", this.reqSndTsMillis)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeLong("resProcTs", this.resProcTs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeLong("resRcvTs", this.resRcvTs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeLong("resRcvTsMillis", this.resRcvTsMillis)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeLong("resSndTs", this.resSndTs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeLong("resSndTsMillis", this.resSndTsMillis)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.id = reader.readLong("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.payload = reader.readByteArray("payload");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.req = reader.readBoolean("req");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.reqCreateTs = reader.readLong("reqCreateTs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.reqProcTs = reader.readLong("reqProcTs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.reqRcvTs = reader.readLong("reqRcvTs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.reqRcvTsMillis = reader.readLong("reqRcvTsMillis");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.reqSndTs = reader.readLong("reqSndTs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.reqSndTsMillis = reader.readLong("reqSndTsMillis");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.resProcTs = reader.readLong("resProcTs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.resRcvTs = reader.readLong("resRcvTs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.resRcvTsMillis = reader.readLong("resRcvTsMillis");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.resSndTs = reader.readLong("resSndTs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.resSndTsMillis = reader.readLong("resSndTsMillis");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        this.onAfterRead();
        return reader.afterMessageRead(IgniteIoTestMessage.class);
    }

    @Override
    public short directType() {
        return -43;
    }

    @Override
    public byte fieldsCount() {
        return 15;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(IgniteIoTestMessage.class, this);
    }
}

